/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.paperplatform;

import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.java.JavaPlugin;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.ArgumentSet;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.arguments.EmptyArg;
import ru.cwcode.commands.arguments.EnumArg;
import ru.cwcode.commands.arguments.ExactStringArg;
import ru.cwcode.commands.arguments.HexColorArg;
import ru.cwcode.commands.arguments.LegacyColorArg;
import ru.cwcode.commands.arguments.ListArg;
import ru.cwcode.commands.arguments.SafetyStringArg;
import ru.cwcode.commands.arguments.basic.BooleanArg;
import ru.cwcode.commands.arguments.basic.DoubleArg;
import ru.cwcode.commands.arguments.basic.IntegerArg;
import ru.cwcode.commands.arguments.basic.StringArg;
import ru.cwcode.commands.arguments.datetime.DurationArg;
import ru.cwcode.commands.arguments.datetime.TimeArg;
import ru.cwcode.commands.arguments.spaced.SafetySpacedStringArg;
import ru.cwcode.commands.arguments.spaced.SpacedListArg;
import ru.cwcode.commands.arguments.spaced.SpacedStringArg;
import ru.cwcode.commands.color.ColoredScheme;
import ru.cwcode.commands.executor.AbstractExecutor;
import ru.cwcode.commands.paperplatform.PrintArguments;
import ru.cwcode.commands.paperplatform.argument.BlockArg;
import ru.cwcode.commands.paperplatform.argument.EnchantmentArg;
import ru.cwcode.commands.paperplatform.argument.MaterialArg;
import ru.cwcode.commands.paperplatform.argument.NearPlayersArg;
import ru.cwcode.commands.paperplatform.argument.OnlinePlayerWithPermissionArg;
import ru.cwcode.commands.paperplatform.argument.OnlinePlayers;
import ru.cwcode.commands.paperplatform.argument.ParticleArg;
import ru.cwcode.commands.paperplatform.argument.PlayerArg;
import ru.cwcode.commands.paperplatform.argument.PotionEffectArg;
import ru.cwcode.commands.paperplatform.argument.SoundArg;
import ru.cwcode.commands.paperplatform.argument.WorldArg;
import ru.cwcode.commands.paperplatform.argument.location.LocationArg;
import ru.cwcode.commands.paperplatform.argument.location.LocationPart;
import ru.cwcode.commands.paperplatform.argument.location.TargetXArg;
import ru.cwcode.commands.paperplatform.features.ItemFromBase64Command;
import ru.cwcode.commands.paperplatform.features.ItemFromSnbtCommand;
import ru.cwcode.commands.paperplatform.features.ItemToBase64Command;
import ru.cwcode.commands.paperplatform.features.ItemToGsonCommand;
import ru.cwcode.commands.paperplatform.features.ItemToSnbtCommand;
import ru.cwcode.commands.paperplatform.paper.PaperPlatform;
import ru.cwcode.commands.paperplatform.paper.PaperSender;
import ru.cwcode.commands.permissions.PermissionGenerationStrategy;
import ru.cwcode.commands.preconditions.PredicatePrecondition;
import ru.cwcode.cwutils.collections.CollectionUtils;
import ru.cwcode.cwutils.l10n.L10n;
import ru.cwcode.cwutils.l10n.PaperL10nPlatform;
import ru.cwcode.cwutils.server.ServerUtils;

public final class PaperMain
extends JavaPlugin {
    public static JavaPlugin plugin;

    public void onDisable() {
    }

    public void onEnable() {
        plugin = this;
        CommandsAPI.setPlatform(new PaperPlatform());
        CommandsAPI.setL10n(new L10n(new PaperL10nPlatform(this, this.getFile())));
        this.sendLogo();
        if (ServerUtils.isVersionBeforeOrEqual1_12_2()) {
            return;
        }
        try {
            new Command("commandsTest", "*").subCommands(new Command("feature").arguments(new ArgumentSet((AbstractExecutor)new ItemToSnbtCommand(), new ExactStringArg("mainItemToSnbt"), new Argument[0]), new ArgumentSet((AbstractExecutor)new ItemToBase64Command(), new ExactStringArg("mainItemToBase64"), new Argument[0]), new ArgumentSet((AbstractExecutor)new ItemToGsonCommand(), new ExactStringArg("mainItemToGson"), new Argument[0]), new ArgumentSet((AbstractExecutor)new ItemFromSnbtCommand(), new ExactStringArg("itemFromSnbt"), new StringArg("snbt")), new ArgumentSet((AbstractExecutor)new ItemFromBase64Command(), new ExactStringArg("itemFromBase64"), new StringArg("base64"))), new Command("preconditionTest").arguments(new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("onlyIfFlying"), new Argument[0]).canExecute(sender -> ((PaperSender)sender).getPlayer().isFlying()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("onlyIfNotFlying"), new Argument[0]).preconditions(new PredicatePrecondition(sender -> !((PaperSender)sender).getPlayer().isFlying(), "\u0418\u0433\u0440\u043e\u043a \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u0442\u043e\u044f\u0442\u044c \u043d\u0430 \u0437\u0435\u043c\u043b\u0435")), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("onlyForPlayer"), new Argument[0]).blockForNonPlayers(), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("onlyForNonPlayer"), new Argument[0]).blockForPlayers()), new Command("bukkit").arguments(new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("block"), new BlockArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("enchantment"), new EnchantmentArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("legacyColor"), new LegacyColorArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("material"), new MaterialArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("onlinePlayers"), new OnlinePlayers()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("particle"), new ParticleArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("player"), new PlayerArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("effect"), new PotionEffectArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("sound"), new SoundArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("world"), new WorldArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("onlinePlayersWithPermission"), new OnlinePlayerWithPermissionArg("*", "admin")), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("nearPlayers"), new NearPlayersArg(10, 10))).subCommands(new Command("target").arguments(new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("XYZ"), LocationArg.xyz), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("X"), new TargetXArg(LocationPart.X)), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("Y"), new TargetXArg(LocationPart.Y)), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("Z"), new TargetXArg(LocationPart.Z)), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("PITCH"), new TargetXArg(LocationPart.PITCH)), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("YAW"), new TargetXArg(LocationPart.YAW)), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("WORLD"), new TargetXArg(LocationPart.WORLD)))), new Command("basic").subCommands(new Command("string").subCommands(new Command("spaced").arguments(new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("simple"), new SpacedStringArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("list"), new SpacedListArg("list", Arrays.asList("one two", "three four"))), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("safeString"), new SafetySpacedStringArg()))).arguments(new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("simple"), new StringArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("list"), new ListArg("list", Arrays.asList("one", "two"))), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("safeString"), new SafetyStringArg())), new Command("auto").arguments(new ArgumentSet((AbstractExecutor)new PrintArguments(), new IntegerArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new DoubleArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new BooleanArg()))).arguments(new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("int"), new IntegerArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("double"), new DoubleArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("boolean"), new BooleanArg())), new Command("datetime").arguments(new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("duration"), new DurationArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("time"), new TimeArg()))).arguments(new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("empty"), new EmptyArg()), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("enum"), new EnumArg((Enum[])EquipmentSlot.values(), "equipmentSlot")), new ArgumentSet((AbstractExecutor)new PrintArguments(), new ExactStringArg("hexColor"), new HexColorArg("color"))).setColorScheme(new ColoredScheme(NamedTextColor.GREEN, NamedTextColor.RED)).setPermissions(PermissionGenerationStrategy.ALL_DENIED).register();
        }
        catch (Exception ex) {
            this.getLogger().warning(ex.getLocalizedMessage());
        }
    }

    private void sendLogo() {
        NamedTextColor randomColor = CollectionUtils.getRandomListEntry(List.of(NamedTextColor.DARK_GREEN, NamedTextColor.DARK_RED, NamedTextColor.DARK_BLUE, NamedTextColor.BLUE, NamedTextColor.YELLOW, NamedTextColor.GOLD, NamedTextColor.GRAY));
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        console.sendMessage("");
        console.sendMessage((Component)Component.text("  ___ _         _  __      __       _   ", (TextColor)randomColor));
        console.sendMessage((Component)Component.text(" / __| |___  __| |_\\ \\    / /__ _ _| |__", (TextColor)randomColor));
        console.sendMessage((Component)Component.text("| (__| / _ \\/ _| / /\\ \\/\\/ / _ \\ '_| / /", (TextColor)randomColor));
        console.sendMessage((Component)Component.text(" \\___|_\\___/\\__|_\\_\\ \\_/\\_/\\___/_| |_\\_\\", (TextColor)randomColor));
        console.sendMessage((Component)Component.text(CommandsAPI.l10n.get("startup.logo.tooltip", new Object[0]), (TextColor)randomColor));
        console.sendMessage("");
    }
}

