/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.bossBar;

import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;

public class LegacyBossBarAdapter {
    static HashMap<UUID, org.bukkit.boss.BossBar> cachedBossBars = new HashMap();

    public static void remove(UUID uuid) {
        cachedBossBars.remove(uuid);
    }

    public static org.bukkit.boss.BossBar get(UUID uuid) {
        return cachedBossBars.get(uuid);
    }

    public static org.bukkit.boss.BossBar merge(UUID uuid, BossBar bossBar) {
        BarStyle barStyle;
        Component name = bossBar.name();
        float progress = bossBar.progress();
        Set<BossBar.Flag> flags = bossBar.flags();
        BossBar.Color color = bossBar.color();
        BossBar.Overlay overlay = bossBar.overlay();
        switch (overlay) {
            case NOTCHED_6: {
                barStyle = BarStyle.SEGMENTED_6;
                break;
            }
            case NOTCHED_10: {
                barStyle = BarStyle.SEGMENTED_10;
                break;
            }
            case NOTCHED_12: {
                barStyle = BarStyle.SEGMENTED_12;
                break;
            }
            case NOTCHED_20: {
                barStyle = BarStyle.SEGMENTED_20;
                break;
            }
            default: {
                barStyle = BarStyle.SOLID;
            }
        }
        BarColor barColor = BarColor.valueOf((String)color.name());
        BarFlag[] barFlags = (BarFlag[])flags.stream().map(flag -> {
            switch (flag) {
                case PLAY_BOSS_MUSIC: {
                    return BarFlag.PLAY_BOSS_MUSIC;
                }
                case DARKEN_SCREEN: {
                    return BarFlag.DARKEN_SKY;
                }
                case CREATE_WORLD_FOG: {
                    return BarFlag.CREATE_FOG;
                }
            }
            return null;
        }).distinct().toArray(BarFlag[]::new);
        org.bukkit.boss.BossBar bossBarLegacy = cachedBossBars.get(uuid);
        if (bossBarLegacy == null) {
            bossBarLegacy = Bukkit.createBossBar((String)"loading...", (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])barFlags);
            cachedBossBars.put(uuid, bossBarLegacy);
        }
        bossBarLegacy.setProgress((double)progress);
        bossBarLegacy.setStyle(barStyle);
        bossBarLegacy.setTitle(LegacyComponentSerializer.legacySection().serialize(name));
        return bossBarLegacy;
    }
}

