/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.confirmable;

import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.cwcode.cwutils.confirmable.ChatOutListener;
import ru.cwcode.cwutils.confirmable.ConfirmRequest;

public class ConfirmAPI {
    static ConcurrentHashMap<CommandSender, ConfirmRequest> requests = new ConcurrentHashMap();

    public static ConfirmableBuilder requestBuilder(CommandSender sender, String confirmableString, long timeToConfirm) {
        return new ConfirmableBuilder(sender, confirmableString, timeToConfirm);
    }

    public static String getString(Player player) {
        return ConfirmAPI.requests.get((Object)player).required;
    }

    public static boolean senderAffected(Player player) {
        return requests.containsKey(player);
    }

    public static void onSuccess(Player player) {
        ConfirmRequest confirmRequest = requests.get(player);
        confirmRequest.stopTimer();
        Bukkit.getScheduler().runTask(confirmRequest.plugin, confirmRequest.onSuccess);
        requests.remove(player);
    }

    public static class ConfirmableBuilder {
        ConfirmRequest request;

        public ConfirmableBuilder(CommandSender sender, String confirmableString, long ticksToRequest) {
            this.request = new ConfirmRequest(sender, confirmableString, ticksToRequest);
        }

        public ConfirmableBuilder success(Runnable success) {
            this.request.onSuccess = success;
            return this;
        }

        public ConfirmableBuilder expired(Runnable expired) {
            this.request.onExpired = expired;
            return this;
        }

        public void register(JavaPlugin plugin) {
            requests.put(this.request.sender, this.request);
            this.request.startTimer(plugin);
            if (!ChatOutListener.IS_REGISTERED) {
                Bukkit.getPluginManager().registerEvents((Listener)new ChatOutListener(), (Plugin)plugin);
                ChatOutListener.IS_REGISTERED = true;
            }
        }
    }
}

