/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.datetime;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StringToDuration {
    private static final HashMap<Character, TemporalUnit> units = new HashMap();
    private static final String unitsString = "%sy %sM %sw %sd %sh %sm %ss ";

    public static boolean isValid(String st) {
        try {
            for (char c : st.toCharArray()) {
                if (c == ' ' || c >= '0' && c <= '9' || StringToDuration.hasUnit(c) || c == 't') continue;
                return false;
            }
            StringToDuration.parse(st);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Duration parse(String line) {
        HashMap<Character, String> parts = StringToDuration.splitParts(line);
        Duration duration = Duration.ofSeconds(0L);
        for (Map.Entry<Character, String> part : parts.entrySet()) {
            if (StringToDuration.hasUnit(part.getKey().charValue())) {
                duration = duration.plus(Duration.of(Long.parseLong(part.getValue()), units.get(part.getKey())));
                continue;
            }
            if (part.getKey().charValue() != 't') continue;
            duration = duration.plus(Duration.ofMillis(Long.parseLong(part.getValue()) * 50L));
        }
        return duration;
    }

    public static String fromDuration(Duration duration) {
        long seconds = duration.getSeconds();
        long years = seconds / 31536000L;
        long months = (seconds %= 31536000L) / 2419200L;
        long weeks = (seconds %= 2419200L) / 604800L;
        long days = (seconds %= 604800L) / 86400L;
        long hours = (seconds %= 86400L) / 3600L;
        long minutes = (seconds %= 3600L) / 60L;
        return String.format(unitsString, years, months, weeks, days, hours, minutes, seconds %= 60L).replaceFirst("0y ", "").replaceFirst("0M ", "").replaceFirst("0w ", "").replaceFirst("0d ", "").replaceFirst("0h ", "").replaceFirst("0m ", "").replaceFirst("0s ", "").stripTrailing();
    }

    @NotNull
    private static HashMap<Character, String> splitParts(String line) {
        StringBuilder currentPart = new StringBuilder();
        HashMap<Character, String> parts = new HashMap<Character, String>();
        if (line.isEmpty()) {
            return parts;
        }
        for (char c : line.toCharArray()) {
            if (c == ' ') continue;
            if (c >= '0' && c <= '9') {
                currentPart.append(c);
                continue;
            }
            if (!StringToDuration.hasUnit(c) && c != 't') continue;
            if (currentPart.length() > 0) {
                parts.put(Character.valueOf(c), currentPart.toString());
            }
            currentPart.setLength(0);
        }
        return parts;
    }

    private static boolean hasUnit(char c) {
        return units.containsKey(Character.valueOf(c));
    }

    static {
        units.put(Character.valueOf('y'), ChronoUnit.YEARS);
        units.put(Character.valueOf('M'), ChronoUnit.MONTHS);
        units.put(Character.valueOf('w'), ChronoUnit.WEEKS);
        units.put(Character.valueOf('d'), ChronoUnit.DAYS);
        units.put(Character.valueOf('h'), ChronoUnit.HOURS);
        units.put(Character.valueOf('m'), ChronoUnit.MINUTES);
        units.put(Character.valueOf('s'), ChronoUnit.SECONDS);
    }
}

