/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.dynamicBossBar.broadcast;

import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.cwutils.dynamicBossBar.broadcast.BroadcastBossBar;
import ru.cwcode.cwutils.scheduler.Scheduler;

public class BroadcastBossBarManager {
    ConcurrentLinkedQueue<BroadcastBossBar> bars = new ConcurrentLinkedQueue();
    JavaPlugin plugin;

    public BroadcastBossBarManager(JavaPlugin plugin, boolean async, int delay) {
        this.plugin = plugin;
        Scheduler.create().async(async).infinite().perform(this::tick).register(plugin, delay);
    }

    public void add(BroadcastBossBar bar) {
        this.removeBar(bar.getUUID());
        this.bars.add(bar);
    }

    public void removeBar(UUID bar) {
        this.getBossBarEntries().removeIf(x -> {
            if (x.getUUID().equals(bar)) {
                x.onRemove();
                return true;
            }
            return false;
        });
    }

    public void removeBar(BroadcastBossBar bar) {
        this.getBossBarEntries().removeIf(x -> {
            if (x.getUUID().equals(bar.getUUID())) {
                x.onRemove();
                return true;
            }
            return false;
        });
    }

    @NotNull
    public Queue<BroadcastBossBar> getBossBarEntries() {
        return this.bars;
    }

    private void tick() {
        if (this.bars == null || this.bars.isEmpty()) {
            return;
        }
        this.bars.removeIf(bar -> {
            if (bar.getShouldRemove().get().booleanValue()) {
                bar.onRemove();
                return true;
            }
            bar.update();
            return false;
        });
    }
}

