/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.persistent;

import java.util.Set;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PersistentHelper {
    JavaPlugin plugin;

    public PersistentHelper(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public static Set<NamespacedKey> getPersistentDataHolderKeys(PersistentDataHolder holder) {
        return holder.getPersistentDataContainer().getKeys();
    }

    public static boolean hasIntTag(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.INTEGER);
    }

    public static void set(PersistentDataHolder holder, NamespacedKey key, int value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)value);
    }

    public static void incrementInt(PersistentDataHolder holder, NamespacedKey key) {
        PersistentHelper.addIntToIntTag(holder, key, 1);
    }

    public static void addIntToIntTag(PersistentDataHolder holder, NamespacedKey key, int value) {
        if (!PersistentHelper.hasIntTag(holder, key)) {
            PersistentHelper.set(holder, key, value);
        } else {
            PersistentHelper.set(holder, key, value + PersistentHelper.get(holder, key, 0));
        }
    }

    public static int get(PersistentDataHolder holder, NamespacedKey key, int defaultValue) {
        if (holder == null) {
            return defaultValue;
        }
        return (Integer)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.INTEGER, (Object)defaultValue);
    }

    public static void decrementInt(PersistentDataHolder holder, NamespacedKey key) {
        PersistentHelper.addIntToIntTag(holder, key, -1);
    }

    public static boolean hasStringTag(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.STRING);
    }

    public static void set(PersistentDataHolder holder, NamespacedKey key, String value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)value);
    }

    public static String get(PersistentDataHolder holder, NamespacedKey key, String defaultValue) {
        if (holder == null) {
            return defaultValue;
        }
        return (String)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.STRING, (Object)defaultValue);
    }

    public static void set(PersistentDataHolder holder, NamespacedKey key, double value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.DOUBLE, (Object)value);
    }

    public static double get(PersistentDataHolder holder, NamespacedKey key, double defaultValue) {
        if (holder == null) {
            return defaultValue;
        }
        return (Double)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.DOUBLE, (Object)defaultValue);
    }

    public static void set(PersistentDataHolder holder, NamespacedKey key, byte[] value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.BYTE_ARRAY, (Object)value);
    }

    public static byte[] get(PersistentDataHolder holder, NamespacedKey key, byte[] defaultValue) {
        if (holder == null) {
            return defaultValue;
        }
        return (byte[])holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.BYTE_ARRAY, (Object)defaultValue);
    }

    public static boolean hasDoubleTag(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.DOUBLE);
    }

    public static boolean hasByteArrTag(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.BYTE_ARRAY);
    }

    public boolean hasIntTag(PersistentDataHolder holder, String key) {
        return PersistentHelper.hasIntTag(holder, new NamespacedKey((Plugin)this.plugin, key));
    }

    public void set(PersistentDataHolder holder, String key, int value) {
        PersistentHelper.set(holder, new NamespacedKey((Plugin)this.plugin, key), value);
    }

    public void incrementInt(PersistentDataHolder holder, String key) {
        PersistentHelper.incrementInt(holder, new NamespacedKey((Plugin)this.plugin, key));
    }

    public void decrementInt(PersistentDataHolder holder, String key) {
        PersistentHelper.decrementInt(holder, new NamespacedKey((Plugin)this.plugin, key));
    }

    public int get(PersistentDataHolder holder, String key, int defaultValue) {
        return PersistentHelper.get(holder, new NamespacedKey((Plugin)this.plugin, key), defaultValue);
    }

    public void addIntToIntTag(PersistentDataHolder holder, String key, int value) {
        PersistentHelper.addIntToIntTag(holder, new NamespacedKey((Plugin)this.plugin, key), value);
    }

    public boolean hasStringTag(PersistentDataHolder holder, String key) {
        return PersistentHelper.hasStringTag(holder, new NamespacedKey((Plugin)this.plugin, key));
    }

    public void set(PersistentDataHolder holder, String key, String value) {
        PersistentHelper.set(holder, new NamespacedKey((Plugin)this.plugin, key), value);
    }

    public String get(PersistentDataHolder holder, String key, String defaultValue) {
        return PersistentHelper.get(holder, new NamespacedKey((Plugin)this.plugin, key), defaultValue);
    }

    public boolean hasDoubleTag(PersistentDataHolder holder, String key) {
        return PersistentHelper.hasStringTag(holder, new NamespacedKey((Plugin)this.plugin, key));
    }

    public void set(PersistentDataHolder holder, String key, double value) {
        PersistentHelper.set(holder, new NamespacedKey((Plugin)this.plugin, key), value);
    }

    public double get(PersistentDataHolder holder, String key, double defaultValue) {
        return PersistentHelper.get(holder, new NamespacedKey((Plugin)this.plugin, key), defaultValue);
    }

    public void set(PersistentDataHolder holder, String key, byte[] value) {
        PersistentHelper.set(holder, new NamespacedKey((Plugin)this.plugin, key), value);
    }

    public boolean hasByteArrTag(PersistentDataHolder holder, String key) {
        return PersistentHelper.hasStringTag(holder, new NamespacedKey((Plugin)this.plugin, key));
    }

    public byte[] get(PersistentDataHolder holder, String key, byte[] defaultValue) {
        return PersistentHelper.get(holder, new NamespacedKey((Plugin)this.plugin, key), defaultValue);
    }
}

