/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.benchmark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.LongStream;
import ru.cwcode.cwutils.benchmark.BenchmarkIteration;
import ru.cwcode.cwutils.benchmark.BenchmarkStage;

public class BenchmarkResult {
    public static HashMap<String, StageResult> calculate(List<BenchmarkIteration> iterations) {
        LinkedHashMap<String, StageResult> resultMap = new LinkedHashMap<String, StageResult>();
        for (BenchmarkIteration iteration : iterations) {
            for (BenchmarkStage stage : iteration.stages) {
                if (!resultMap.containsKey(stage.name)) {
                    resultMap.put(stage.name, new StageResult());
                }
                if (stage.getElapsedTime() <= 0L) continue;
                resultMap.get(stage.name).add(stage.getElapsedTime());
            }
        }
        return resultMap;
    }

    static class StageResult {
        List<Long> elapsed = new ArrayList<Long>();

        StageResult() {
        }

        public long getMax() {
            return this.elapsed.stream().flatMapToLong(LongStream::of).max().orElse(-1L);
        }

        public long getMin() {
            return this.elapsed.stream().flatMapToLong(LongStream::of).min().orElse(-1L);
        }

        public double getAvg() {
            return this.elapsed.stream().flatMapToLong(LongStream::of).average().orElse(-1.0);
        }

        public int getStarts() {
            return this.elapsed.size();
        }

        public void add(long elapsedTime) {
            this.elapsed.add(elapsedTime);
        }
    }
}

