/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.craftable;

import java.util.Collections;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public interface Craftable {
    public String getName();

    public ItemStack getResult();

    public String[] getShape();

    public Map<Character, String> getRecipe();

    default public Map<String, ItemStack> getCustomIngredients() {
        return Collections.emptyMap();
    }

    default public NamespacedKey getNamespacedKey(JavaPlugin plugin) {
        return new NamespacedKey((Plugin)plugin, Craftable.getKeyPrefix() + "_" + this.getName());
    }

    default public void register(JavaPlugin plugin) {
        Map<Character, String> recipe = this.getRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        String[] shape = this.getShape();
        if (shape.length == 0) {
            return;
        }
        NamespacedKey namespacedKey = this.getNamespacedKey(plugin);
        if (namespacedKey == null) {
            return;
        }
        ShapedRecipe shapedRecipe = new ShapedRecipe(namespacedKey, this.getResult());
        shapedRecipe.shape(shape);
        Map<String, ItemStack> ingredients = this.getCustomIngredients();
        for (char character : recipe.keySet()) {
            String ingredient = recipe.get(Character.valueOf(character));
            ItemStack itemStack = ingredients.get(ingredient);
            if (itemStack != null) {
                shapedRecipe.setIngredient(character, itemStack.clone());
                continue;
            }
            Material material = Material.matchMaterial((String)ingredient);
            if (material != null && material.isItem()) {
                shapedRecipe.setIngredient(character, material);
                continue;
            }
            Bukkit.getConsoleSender().sendMessage("Can't register craft for custom item " + this.getName());
            Bukkit.getConsoleSender().sendMessage("Ingredient " + ingredient + " is not custom item or material");
            return;
        }
        Bukkit.addRecipe((Recipe)shapedRecipe);
    }

    default public void unregister(JavaPlugin plugin) {
        NamespacedKey namespacedKey = this.getNamespacedKey(plugin);
        if (namespacedKey == null) {
            return;
        }
        Bukkit.removeRecipe((NamespacedKey)namespacedKey);
    }

    public static String getKeyPrefix() {
        return "craftable";
    }
}

