/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag.item;

import com.saicone.rtag.item.ItemData;
import com.saicone.rtag.item.ItemMirror;
import com.saicone.rtag.item.ItemObject;
import com.saicone.rtag.item.mirror.IAttributeMirror;
import com.saicone.rtag.item.mirror.IBundleMirror;
import com.saicone.rtag.item.mirror.IComponentMirror;
import com.saicone.rtag.item.mirror.IContainerMirror;
import com.saicone.rtag.item.mirror.IDisplayMirror;
import com.saicone.rtag.item.mirror.IEffectMirror;
import com.saicone.rtag.item.mirror.IEnchantMirror;
import com.saicone.rtag.item.mirror.IMaterialMirror;
import com.saicone.rtag.item.mirror.IPotionMirror;
import com.saicone.rtag.item.mirror.ISkullOwnerMirror;
import com.saicone.rtag.stream.TStream;
import com.saicone.rtag.tag.TagBase;
import com.saicone.rtag.tag.TagCompound;
import com.saicone.rtag.util.ChatComponent;
import com.saicone.rtag.util.ServerInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemTagStream
extends TStream<ItemStack> {
    public static final ItemTagStream INSTANCE = ItemTagStream.ofVersion(8.0f, ServerInstance.VERSION);
    private final List<ItemMirror> mirror;
    private final float version;
    private final String versionKey;

    public static ItemTagStream ofVersion(float minVersion, float currentVersion) {
        return ItemTagStream.ofVersion(minVersion, currentVersion, "rtagDataVersion");
    }

    public static ItemTagStream ofVersion(float minVersion, float currentVersion, String versionKey) {
        if (minVersion > currentVersion) {
            throw new IllegalArgumentException("The minimum supported version cannot be less than current server version");
        }
        ArrayList<ItemMirror> mirrors = new ArrayList<ItemMirror>();
        ItemTagStream instance = new ItemTagStream(mirrors, currentVersion, versionKey);
        if (minVersion <= 20.03f) {
            if (minVersion <= 20.01f) {
                mirrors.add(new IPotionMirror(minVersion < 9.0f));
            }
            if (minVersion < 16.0f) {
                mirrors.add(new ISkullOwnerMirror());
                mirrors.add(new IAttributeMirror());
            }
            mirrors.add(new IMaterialMirror());
            if (minVersion < 14.0f) {
                mirrors.add(new IDisplayMirror(minVersion < 13.0f));
            }
            if (minVersion < 13.0f || currentVersion < 13.0f) {
                mirrors.add(new IEnchantMirror(currentVersion));
            }
            if (currentVersion >= 9.0f) {
                mirrors.add(new IContainerMirror(instance, false));
                if (currentVersion >= 14.0f) {
                    mirrors.add(new IEffectMirror(currentVersion));
                    if (currentVersion >= 17.0f) {
                        mirrors.add(new IBundleMirror(instance, false));
                    }
                }
            }
            if (currentVersion >= 20.04f) {
                mirrors.add(new IComponentMirror());
            } else {
                mirrors.add(0, new IComponentMirror());
            }
        } else {
            mirrors.add(new IComponentMirror());
            mirrors.add(new IMaterialMirror());
            mirrors.add(new IContainerMirror(instance, true));
            mirrors.add(new IBundleMirror(instance, true));
        }
        return instance;
    }

    public ItemTagStream() {
        this(new ArrayList<ItemMirror>());
    }

    public ItemTagStream(List<ItemMirror> mirror) {
        this(mirror, ServerInstance.VERSION, "rtagDataVersion");
    }

    public ItemTagStream(List<ItemMirror> mirror, float version, String versionKey) {
        this.mirror = mirror;
        this.version = version;
        this.versionKey = versionKey;
    }

    public List<ItemMirror> getMirror() {
        return this.mirror;
    }

    public float getVersion() {
        return this.version;
    }

    public Float getVersion(Object compound) {
        Object version = TagBase.getValue(TagCompound.get(compound, this.getVersionKey()));
        if (version instanceof Number) {
            return Float.valueOf(((Number)version).floatValue());
        }
        return ItemData.getItemVersion(compound);
    }

    public String getVersionKey() {
        return this.versionKey;
    }

    @Override
    public Object extract(ItemStack object) {
        Object compound = ItemObject.save(ItemObject.asNMSCopy(object));
        try {
            this.onSave(compound);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return compound;
    }

    @Override
    public ItemStack build(Object compound) {
        try {
            this.onLoad(compound);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ItemObject.asBukkitCopy(ItemObject.newItem(compound));
    }

    public Map<String, Object> toReadableMap(ItemStack item) {
        return this.parseMap(this.toMap(item), this.getVersion(), true);
    }

    public ItemStack fromReadableMap(Map<String, Object> map) {
        if (map.containsKey(this.getVersionKey())) {
            return (ItemStack)this.fromMap(this.parseMap(map, ((Number)map.getOrDefault(this.getVersionKey(), Float.valueOf(this.getVersion()))).floatValue(), false));
        }
        return (ItemStack)this.fromMap(map);
    }

    private Map<String, Object> parseMap(Map<String, Object> map, float version, boolean readable) {
        Map components;
        boolean useComponent;
        if (version < 13.0f) {
            return map;
        }
        boolean bl = useComponent = version >= 20.04f;
        if (useComponent) {
            components = (Map)map.get("components");
        } else {
            Map tag = (Map)map.get("tag");
            if (tag == null) {
                return map;
            }
            components = (Map)tag.get("display");
        }
        if (components != null) {
            List lore;
            String nameKey = useComponent ? "minecraft:custom_name" : "Name";
            String name = (String)components.get(nameKey);
            if (name != null) {
                components.put(nameKey, this.parseText(name, readable));
            }
            if (version >= 14.0f && (lore = (List)components.get(useComponent ? "minecraft:lore" : "Lore")) != null) {
                lore.replaceAll(line -> this.parseText((String)line, readable));
            }
        }
        return map;
    }

    private String parseText(String s, boolean readable) {
        if (ChatComponent.isChatComponent(s)) {
            if (readable) {
                return ChatComponent.toString(s);
            }
        } else if (!readable) {
            return ChatComponent.toJson(s);
        }
        return s;
    }

    public void onSave(Object compound) {
        if (compound != null) {
            TagCompound.set(compound, this.getVersionKey(), TagBase.newTag(Float.valueOf(this.getVersion())));
        }
    }

    public void onLoad(Object compound) {
        Float version = this.getVersion(compound);
        if (version != null && !this.versionMatches(version.floatValue(), this.getVersion())) {
            this.onLoad(compound, version.floatValue(), this.getVersion());
        }
    }

    public void onLoad(Object compound, float from, float to) {
        String id = (String)TagBase.getValue(TagCompound.get(compound, "id"));
        if (id == null) {
            return;
        }
        Object components = TagCompound.get(compound, from >= 20.04f ? "components" : "tag");
        if (from > to) {
            if (components == null) {
                for (ItemMirror item : this.mirror) {
                    item.downgrade(compound, id, from, to);
                }
            } else {
                for (ItemMirror item : this.mirror) {
                    item.downgrade(compound, id, components, from, to);
                }
            }
        } else if (components == null) {
            for (ItemMirror item : this.mirror) {
                item.upgrade(compound, id, from, to);
            }
        } else {
            for (ItemMirror item : this.mirror) {
                item.upgrade(compound, id, components, from, to);
            }
        }
    }

    protected boolean versionMatches(float from, float to) {
        if (from < 19.02f && to < 19.02f) {
            return (int)from == (int)to;
        }
        return from == to;
    }

    @Override
    public String listToBase64(List<ItemStack> items) {
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            if (item == null || item.getType() == Material.AIR) continue;
            filter.add(item);
        }
        return super.listToBase64(filter);
    }
}

