/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.paperplatform.argument;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Sender;

public class OnlinePlayers
extends Argument {
    @Override
    public boolean valid(String raw) {
        return Bukkit.getPlayer((String)raw) != null;
    }

    public List<String> completions(Sender sender) {
        ArrayList<String> list = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            list.add(player.getName());
        }
        return list;
    }

    @Override
    public String argumentName() {
        return CommandsAPI.l10n.get("argument.onlinePlayer.name", new Object[0]);
    }

    @Override
    public Component invalidMessage(Command command, Sender sender, String written) {
        return Component.text(CommandsAPI.l10n.get("argument.onlinePlayer.invalid", written), command.getColorScheme().main());
    }

    @Override
    public Object map() {
        return Bukkit.getPlayer((String)this.raw);
    }
}

