/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands;

import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.arguments.ExactStringArg;
import ru.cwcode.commands.color.ColorGenerationStrategy;
import ru.cwcode.cwutils.messages.Message;
import ru.cwcode.cwutils.messages.MessageReturn;

public abstract class Argument {
    protected String raw;
    private String tag = "";
    private boolean optional;

    protected Argument(String raw) {
        this.raw = raw;
    }

    public Argument() {
    }

    @NotNull
    public TextComponent toComponent(ColorGenerationStrategy color, boolean canPerformedBy) {
        if (this.isOptional()) {
            return Component.text("[" + this.argumentName() + "]", color.optional(canPerformedBy));
        }
        if (this instanceof ExactStringArg) {
            return Component.text(this.argumentName(), color.subcommand(canPerformedBy));
        }
        TextComponent component = Component.text("<" + this.argumentName() + ">", color.argument(canPerformedBy));
        if (this.hint().isEmpty()) {
            return component;
        }
        return (TextComponent)component.hoverEvent(HoverEvent.showText(Component.text(this.hint(), color.accent(canPerformedBy))));
    }

    public String toReadableString() {
        if (this.isOptional()) {
            return "[" + this.argumentName() + "]";
        }
        if (this instanceof ExactStringArg) {
            return this.argumentName();
        }
        String args = "<" + this.argumentName() + ">";
        if (this.hint().isEmpty()) {
            return args;
        }
        return args;
    }

    public abstract boolean valid(String var1);

    public boolean valid(Sender sender, String raw, List<String> arguments) {
        return this.valid(raw);
    }

    public abstract Collection<String> completions(Sender var1);

    public Collection<String> completions(Sender sender, List<String> written) {
        return this.completions(sender);
    }

    public Argument optional() {
        this.optional = true;
        return this;
    }

    public Argument optional(String defaultValue) {
        this.optional = true;
        this.raw = defaultValue;
        return this;
    }

    public abstract String argumentName();

    public boolean notNull() {
        return this.raw != null;
    }

    public Integer toInt() {
        try {
            if (this.notNull()) {
                return Integer.parseInt(this.raw);
            }
        }
        catch (Exception exception) {
            CommandsAPI.getPlatform().getLogger().warn(CommandsAPI.l10n.get("argument.cast.integer.error", this.raw, this.argumentName()));
        }
        return null;
    }

    public Float toFloat() {
        try {
            if (this.notNull()) {
                return Float.valueOf(Float.parseFloat(this.raw));
            }
        }
        catch (Exception exception) {
            CommandsAPI.getPlatform().getLogger().warn(CommandsAPI.l10n.get("argument.cast.float.error", this.raw, this.argumentName()));
        }
        return null;
    }

    public String toString() {
        if (this.notNull()) {
            return this.raw;
        }
        CommandsAPI.getPlatform().getLogger().warn(CommandsAPI.l10n.get("argument.cast.string.error", this.raw != null ? this.raw : "~null~", this.argumentName()));
        return null;
    }

    public Double toDouble() {
        try {
            if (this.notNull()) {
                return Double.parseDouble(this.raw);
            }
        }
        catch (Exception exception) {
            CommandsAPI.getPlatform().getLogger().warn(CommandsAPI.l10n.get("argument.cast.double.error", this.raw, this.argumentName()));
        }
        return null;
    }

    public Boolean toBoolean() {
        try {
            if (this.notNull()) {
                return Boolean.parseBoolean(this.raw);
            }
        }
        catch (Exception exception) {
            CommandsAPI.getPlatform().getLogger().warn(CommandsAPI.l10n.get("argument.cast.boolean.error", this.raw, this.argumentName()));
        }
        return null;
    }

    public boolean isOptional() {
        return this.optional;
    }

    protected String hint() {
        return "";
    }

    public Argument newInstance() throws MessageReturn {
        try {
            return (Argument)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ignored) {
            throw new MessageReturn(Message.from(CommandsAPI.l10n.get("argument.newInstance.error", this.argumentName())));
        }
    }

    public Argument tag(String tag) {
        this.tag = tag;
        return this;
    }

    public String getTag() {
        return this.tag.isEmpty() ? this.argumentName() : this.tag;
    }

    public Component invalidMessage(Command command, Sender sender, String written) {
        ColorGenerationStrategy colorScheme = command.getColorScheme();
        return ((TextComponent)Component.text(written, colorScheme.accent(true)).append(Component.text(" " + CommandsAPI.l10n.get("argument.invalid.error", new Object[0]) + " ", colorScheme.main()))).append(Component.text(this.argumentName(), colorScheme.accent(true)));
    }

    @ApiStatus.OverrideOnly
    public Object map() {
        return this.raw;
    }
}

