/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.paperplatform.paper;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Platform;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.paperplatform.PaperMain;
import ru.cwcode.commands.paperplatform.paper.PaperCommand;
import ru.cwcode.commands.paperplatform.paper.PaperSender;
import ru.cwcode.cwutils.collections.CollectionUtils;
import ru.cwcode.cwutils.logger.Logger;
import ru.cwcode.cwutils.logger.PaperLogger;
import ru.cwcode.cwutils.messages.MessageReturn;
import ru.cwcode.cwutils.messages.TargetableMessageReturn;
import ru.cwcode.cwutils.reflection.ReflectionUtils;

public class PaperPlatform
extends Platform {
    private final Logger logger = new PaperLogger(PaperMain.plugin);
    HashMap<String, Command> registeredCommands = new HashMap();

    public HashMap<String, Command> registeredCommands() {
        return this.registeredCommands;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void registerCommand(Command command) {
        PluginCommand pluginCommand = Bukkit.getPluginCommand((String)command.getName());
        if (pluginCommand == null) {
            this.logger.warn(CommandsAPI.l10n.get("paperPlatform.commandIsNotRegistered", command.getName()));
            return;
        }
        PaperCommand paperCommand = new PaperCommand(command);
        pluginCommand.setExecutor((CommandExecutor)paperCommand.getCommandParser());
        pluginCommand.setTabCompleter((TabCompleter)paperCommand.getTabCompleter());
        CommandMap commandMap = ReflectionUtils.getFieldValue(Bukkit.getPluginManager(), "commandMap", CommandMap.class);
        Plugin plugin = pluginCommand.getPlugin();
        if (!command.aliases().isEmpty()) {
            command.aliases(new ArrayList<String>(CollectionUtils.combine(pluginCommand.getAliases(), command.aliases())));
            this.registerNewAliases(command, (org.bukkit.command.Command)pluginCommand, commandMap, plugin);
        }
        if (pluginCommand.getDescription().isEmpty()) {
            pluginCommand.setDescription(command.description());
        }
        if (pluginCommand.getPermission() == null) {
            pluginCommand.setPermission(command.getPermission());
        }
    }

    private void registerNewAliases(Command command, org.bukkit.command.Command paperCommand, CommandMap commandMap, Plugin plugin) {
        try {
            Field activeAliases = paperCommand.getClass().getSuperclass().getDeclaredField("activeAliases");
            activeAliases.setAccessible(true);
            ((List)activeAliases.get(paperCommand)).addAll(command.aliases());
            Field aliasesField = paperCommand.getClass().getSuperclass().getDeclaredField("aliases");
            aliasesField.setAccessible(true);
            ((List)aliasesField.get(paperCommand)).addAll(command.aliases());
            Method registerAlias = commandMap.getClass().getMethod("register", String.class, org.bukkit.command.Command.class);
            registerAlias.setAccessible(true);
            registerAlias.invoke((Object)commandMap, plugin.getName(), paperCommand);
            this.registeredCommands.put(command.getName(), command);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.warn(CommandsAPI.l10n.get("paperPlatform.cannotRegisterAliases", command.getName()));
        }
    }

    @Override
    public void handleExecutionException(Exception exception, Command command, Sender sender) {
        if (exception instanceof MessageReturn) {
            MessageReturn messageReturn = (MessageReturn)exception;
            if (messageReturn.isStyled()) {
                sender.sendMessage(messageReturn.getComponentMessage());
            } else {
                sender.sendMessage(messageReturn.getComponentMessage().color(command.getColorScheme().main()));
            }
            return;
        }
        if (exception instanceof TargetableMessageReturn) {
            sender.sendMessage(((TargetableMessageReturn)exception).getMessage(((PaperSender)sender).getCommandSender()));
            return;
        }
        String localizedMessage = exception.getLocalizedMessage();
        if (localizedMessage == null) {
            localizedMessage = CommandsAPI.l10n.get("paperPlatform.unknownError", new Object[0]);
        }
        sender.sendMessage(Component.text(localizedMessage, command.getColorScheme().main()));
        CommandsAPI.getPlatform().getLogger().warn(CommandsAPI.l10n.get("paperPlatform.executionError", this.getClass().getName()));
        exception.printStackTrace();
    }
}

