/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.dynamicBossBar.v2;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import ru.cwcode.cwutils.numbers.NumbersUtils;

public class PersonalBossBar {
    protected final UUID uuid;
    protected final Function<Player, Component> title;
    protected final Function<Player, Float> progress;
    protected final Function<Player, Boolean> shouldDisplay;
    protected final Function<Player, BossBar.Color> color;
    protected final Function<Player, BossBar.Overlay> overlay;
    protected final Supplier<Boolean> shouldRemove;
    Map<Player, BossBar> bossBars = new ConcurrentHashMap<Player, BossBar>();

    protected void delete() {
        this.bossBars.forEach(this::hide);
        this.bossBars = new ConcurrentHashMap<Player, BossBar>();
    }

    protected void remove(Player player) {
        BossBar bar = this.bossBars.remove(player);
        if (bar != null) {
            this.hide(player, bar);
        }
    }

    protected boolean shouldRemove() {
        return this.shouldRemove.get();
    }

    protected void update(Player player) {
        if (!player.isOnline()) {
            return;
        }
        BossBar bossBar = this.bossBars.get(player);
        Boolean shouldDisplay = this.shouldDisplay.apply(player);
        if (bossBar == null && shouldDisplay.booleanValue()) {
            bossBar = this.createBossBar();
        }
        if (bossBar == null) {
            return;
        }
        if (!shouldDisplay.booleanValue()) {
            this.hide(player, bossBar);
            return;
        }
        bossBar.name(this.title.apply(player));
        bossBar.progress((float)NumbersUtils.bound(this.progress.apply(player).floatValue(), 0.0, 1.0));
        bossBar.color(this.color.apply(player));
        bossBar.overlay(this.overlay.apply(player));
        this.show(player, bossBar);
    }

    protected BossBar createBossBar() {
        return BossBar.bossBar(Component.empty(), 1.0f, BossBar.Color.WHITE, BossBar.Overlay.NOTCHED_12);
    }

    protected void hide(Player player, BossBar bossBar) {
        player.hideBossBar(bossBar);
    }

    protected void show(Player player, BossBar bossBar) {
        player.showBossBar(bossBar);
    }

    public PersonalBossBar(UUID uuid, Function<Player, Component> title, Function<Player, Float> progress, Function<Player, Boolean> shouldDisplay, Function<Player, BossBar.Color> color, Function<Player, BossBar.Overlay> overlay, Supplier<Boolean> shouldRemove) {
        this.uuid = uuid;
        this.title = title;
        this.progress = progress;
        this.shouldDisplay = shouldDisplay;
        this.color = color;
        this.overlay = overlay;
        this.shouldRemove = shouldRemove;
    }
}

