/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.dynamicBossBar.v2;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.cwcode.cwutils.dynamicBossBar.v2.PersonalBossBar;
import ru.cwcode.cwutils.event.EventHandler;
import ru.cwcode.cwutils.scheduler.Scheduler;

public class PersonalBossBarManager {
    ConcurrentHashMap<UUID, PersonalBossBar> bars = new ConcurrentHashMap();
    JavaPlugin plugin;

    public PersonalBossBarManager(JavaPlugin plugin, boolean async, int delay) {
        this.plugin = plugin;
        Scheduler.create().async(async).infinite().perform(this::tick).register(plugin, delay);
        new EventHandler<PlayerQuitEvent>(PlayerQuitEvent.class, event -> this.onQuit(event.getPlayer()), (Plugin)plugin);
    }

    public void add(PersonalBossBar personalBossBar) {
        this.bars.put(personalBossBar.uuid, personalBossBar);
    }

    public void remove(PersonalBossBar personalBossBar) {
        this.bars.remove(personalBossBar.uuid);
        personalBossBar.delete();
    }

    protected void onQuit(Player player) {
        this.bars.values().forEach(personalBossBar -> personalBossBar.remove(player));
    }

    protected void tick() {
        Collection onlinePlayers = Bukkit.getOnlinePlayers();
        this.bars.entrySet().removeIf(entry -> ((PersonalBossBar)entry.getValue()).shouldRemove());
        for (PersonalBossBar personalBossBar : this.bars.values()) {
            for (Player player : onlinePlayers) {
                personalBossBar.update(player);
            }
        }
    }
}

