/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.items;

import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public interface Rechargeable {
    public long getRecharge(NamespacedKey var1);

    default public long getRecharge() {
        return this.getRecharge(this.getRechargeKey());
    }

    public NamespacedKey getRechargeKey(String var1);

    default public NamespacedKey getRechargeKey() {
        return this.getRechargeKey("");
    }

    default public long getTimeStamp(NamespacedKey rechargeKey, ItemStack itemStack) {
        return (Long)itemStack.getItemMeta().getPersistentDataContainer().getOrDefault(rechargeKey, PersistentDataType.LONG, (Object)0L);
    }

    default public long getTimeStamp(ItemStack itemStack) {
        NamespacedKey rechargeKey = this.getRechargeKey();
        return this.getTimeStamp(rechargeKey, itemStack);
    }

    default public boolean isInRecharge(NamespacedKey rechargeKey, ItemStack itemStack) {
        long coolDown = this.getTimeStamp(rechargeKey, itemStack) + this.getRecharge(rechargeKey) * 1000L;
        return coolDown > System.currentTimeMillis();
    }

    default public boolean isInRecharge(ItemStack itemStack) {
        NamespacedKey rechargeKey = this.getRechargeKey();
        return this.isInRecharge(rechargeKey, itemStack);
    }

    default public void setRecharge(NamespacedKey rechargeKey, ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.getPersistentDataContainer().set(rechargeKey, PersistentDataType.LONG, (Object)System.currentTimeMillis());
        itemStack.setItemMeta(itemMeta);
    }

    default public void setRecharge(ItemStack itemStack) {
        NamespacedKey rechargeKey = this.getRechargeKey();
        this.setRecharge(rechargeKey, itemStack);
    }
}

