/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.player.hidder;

import java.time.Duration;
import java.util.Objects;
import ru.cwcode.cwutils.player.hidder.HideType;

public class HideOption {
    private HideType type;
    private long expire;

    protected HideOption() {
    }

    public HideOption(HideType type, long expire) {
        this.type = type;
        this.expire = expire;
    }

    public HideOption(HideType type, Duration duration) {
        this(type, System.currentTimeMillis() + duration.toMillis());
    }

    public HideType getType() {
        return this.type;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expire;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HideOption that = (HideOption)obj;
        return Objects.equals((Object)this.type, (Object)that.type) && this.expire == that.expire;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.expire});
    }

    public String toString() {
        return "HideOption[type=" + this.type + ", expire=" + this.expire + "]";
    }
}

