/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.player.hidder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import ru.cwcode.cwutils.player.hidder.HideOption;

public final class HideOptions<Option extends HideOption> {
    private final Map<UUID, Option> hiddenPlayers = new HashMap<UUID, Option>();

    public boolean hasOption(UUID hidden) {
        return this.getHideOption(hidden).isPresent();
    }

    public Optional<Option> getHideOption(UUID hidden) {
        HideOption hideOption = (HideOption)this.hiddenPlayers.get(hidden);
        if (hideOption == null) {
            return Optional.empty();
        }
        if (!this.isValid(hideOption)) {
            this.hiddenPlayers.remove(hidden);
            return Optional.empty();
        }
        return Optional.of(hideOption);
    }

    public void hide(UUID hidden, Option options) {
        this.hiddenPlayers.put(hidden, options);
    }

    public void show(UUID hidden, Predicate<Option> showIf) {
        HideOption hideOption = (HideOption)this.hiddenPlayers.get(hidden);
        if (hideOption != null && showIf.test(hideOption)) {
            this.hiddenPlayers.remove(hidden);
        }
    }

    public void show(UUID hidden) {
        this.show(hidden, option -> true);
    }

    public boolean isEmpty() {
        return this.hiddenPlayers.isEmpty();
    }

    public Map<UUID, Option> getHideOptions() {
        if (!this.hiddenPlayers.isEmpty()) {
            this.hiddenPlayers.entrySet().removeIf(entry -> !this.isValid((HideOption)entry.getValue()));
        }
        return Collections.unmodifiableMap(this.hiddenPlayers);
    }

    private boolean isValid(Option hideOption) {
        return !((HideOption)hideOption).isExpired();
    }
}

