/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.player.hidder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.cwcode.cwutils.player.hidder.HideOption;
import ru.cwcode.cwutils.player.hidder.HideOptions;
import ru.cwcode.cwutils.player.hidder.HideType;
import ru.cwcode.cwutils.player.hidder.HiderListener;

public class PlayerHider<Option extends HideOption> {
    private final JavaPlugin plugin;
    private final Map<UUID, Option> hiddenForAllPlayers = new HashMap<UUID, Option>();
    private final Map<UUID, HideOptions<Option>> options = new HashMap<UUID, HideOptions<Option>>();
    private final Map<UUID, Set<UUID>> cache = new HashMap<UUID, Set<UUID>>();

    public PlayerHider(JavaPlugin plugin, long period) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)new HiderListener(this), (Plugin)plugin);
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, this::scheduler, 0L, period);
    }

    public HideOptions<Option> getHiddenPlayers(UUID player) {
        HideOptions hideOptions = this.options.getOrDefault(player, new HideOptions());
        if (this.options.containsKey(player) && hideOptions.isEmpty()) {
            this.options.remove(player);
        }
        return hideOptions;
    }

    public HideOptions<Option> getHiddenPlayers(Player onlinePlayer) {
        return this.getHiddenPlayers(onlinePlayer.getUniqueId());
    }

    public boolean isHidden(UUID player, UUID hidden) {
        return this.getHiddenPlayers(player).hasOption(hidden);
    }

    public boolean isHidden(Player onlinePlayer, Player hiddenPlayer) {
        return this.isHidden(onlinePlayer.getUniqueId(), hiddenPlayer.getUniqueId());
    }

    public boolean isHiddenFor(UUID hidden, UUID player) {
        if (hidden.equals(player)) {
            return false;
        }
        boolean isHiddenForAll = this.isHiddenForAll(hidden);
        HideOptions<Option> hideOptions = this.getHiddenPlayers(player);
        if (hideOptions.isEmpty()) {
            return isHiddenForAll;
        }
        HideOption hideOption = hideOptions.getHideOption(hidden).orElse(null);
        if (hideOption == null) {
            return isHiddenForAll;
        }
        if (hideOption.getType() == HideType.HIDE_ONLY_FOR) {
            return true;
        }
        if (hideOption.getType() == HideType.VIEW_ONLY_FOR) {
            return false;
        }
        return isHiddenForAll;
    }

    public boolean isHiddenFor(Player hiddenPlayer, Player onlinePlayer) {
        return this.isHiddenFor(hiddenPlayer.getUniqueId(), onlinePlayer.getUniqueId());
    }

    public boolean isHiddenForAll(UUID hidden) {
        HideOption hideOption = (HideOption)this.hiddenForAllPlayers.get(hidden);
        if (hideOption == null) {
            return false;
        }
        if (hideOption.isExpired()) {
            this.hiddenForAllPlayers.remove(hidden);
            return false;
        }
        return true;
    }

    public boolean isHiddenForAll(Player hiddenPlayer) {
        return this.isHiddenForAll(hiddenPlayer.getUniqueId());
    }

    public void hide(Player hiddenPlayer, Option hideOption, Player ... players) {
        UUID hidden = hiddenPlayer.getUniqueId();
        HideType type = ((HideOption)hideOption).getType();
        if (type == HideType.VIEW_ONLY_FOR) {
            this.hiddenForAllPlayers.put(hidden, hideOption);
        }
        for (Player onlinePlayer : players) {
            UUID player = onlinePlayer.getUniqueId();
            if (hidden.equals(player)) continue;
            HideOptions<Option> hideOptions = this.gerOrCreateHiddenPlayers(hidden);
            hideOptions.hide(hidden, hideOption);
            Set<UUID> cash = this.getOrCreateCache(hidden);
            cash.add(player);
            this.updateHidden(hiddenPlayer);
        }
    }

    public void hideGroup(Option hideOption, Player ... players) {
        for (Player onlinePlayer : players) {
            this.hide(onlinePlayer, hideOption, players);
        }
    }

    public void showFor(Player hiddenPlayer, Player onlinePlayer) {
        UUID hidden = hiddenPlayer.getUniqueId();
        UUID player = onlinePlayer.getUniqueId();
        onlinePlayer.showPlayer((Plugin)this.plugin, hiddenPlayer);
        this.getHiddenPlayers(player).show(hidden);
        this.getCache(hidden).remove(player);
    }

    public void show(Player hiddenPlayer, Predicate<Option> showIf) {
        Set<UUID> cache;
        UUID hidden = hiddenPlayer.getUniqueId();
        boolean changed = false;
        HideOption hideOption = (HideOption)this.hiddenForAllPlayers.get(hidden);
        if (hideOption != null && showIf.test(hideOption)) {
            this.hiddenForAllPlayers.remove(hidden);
            changed = true;
        }
        if (!(cache = this.getCache(hidden)).isEmpty()) {
            for (UUID player : new HashSet<UUID>(cache)) {
                HideOptions<Option> hideOptions = this.getHiddenPlayers(player);
                hideOptions.show(hidden, showIf);
                if (hideOptions.hasOption(hidden)) continue;
                cache.remove(player);
                changed = true;
            }
        }
        if (changed) {
            this.updateHidden(hiddenPlayer);
        }
    }

    public void show(Player hiddenPlayer) {
        this.show(hiddenPlayer, option -> true);
    }

    public void updateHidden(Player hiddenPlayer) {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            boolean isHidden = this.isHiddenFor(hiddenPlayer, onlinePlayer);
            if (isHidden) {
                onlinePlayer.hidePlayer((Plugin)this.plugin, hiddenPlayer);
                continue;
            }
            onlinePlayer.showPlayer((Plugin)this.plugin, hiddenPlayer);
        }
    }

    public void updateViewer(Player onlinePlayer) {
        for (Player hiddenPlayer : Bukkit.getOnlinePlayers()) {
            boolean isHidden = this.isHiddenFor(hiddenPlayer, onlinePlayer);
            if (isHidden) {
                onlinePlayer.hidePlayer((Plugin)this.plugin, hiddenPlayer);
                continue;
            }
            onlinePlayer.showPlayer((Plugin)this.plugin, hiddenPlayer);
        }
    }

    private void scheduler() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            this.updateHidden(onlinePlayer);
        }
    }

    private HideOptions<Option> gerOrCreateHiddenPlayers(UUID player) {
        return this.options.computeIfAbsent(player, k -> new HideOptions());
    }

    private Set<UUID> getCache(UUID hidden) {
        Set cache = this.cache.getOrDefault(hidden, new HashSet());
        if (this.cache.containsKey(hidden) && cache.isEmpty()) {
            this.cache.remove(hidden);
        }
        return cache;
    }

    private Set<UUID> getOrCreateCache(UUID hidden) {
        return this.cache.computeIfAbsent(hidden, k -> new HashSet());
    }
}

