/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag.item.mirror;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.saicone.rtag.Rtag;
import com.saicone.rtag.item.ItemMirror;
import com.saicone.rtag.tag.TagBase;
import com.saicone.rtag.tag.TagCompound;
import com.saicone.rtag.util.ItemMaterialTag;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class IMaterialMirror
implements ItemMirror {
    private static final String SAVED_ID = "savedID";
    private static final Set<String> DAMAGEABLE = Set.of("minecraft:bow", "minecraft:carrot_on_a_stick", "minecraft:chainmail_boots", "minecraft:chainmail_chestplate", "minecraft:chainmail_helmet", "minecraft:chainmail_leggings", "minecraft:diamond_axe", "minecraft:diamond_boots", "minecraft:diamond_chestplate", "minecraft:diamond_helmet", "minecraft:diamond_hoe", "minecraft:diamond_leggings", "minecraft:diamond_pickaxe", "minecraft:diamond_shovel", "minecraft:diamond_sword", "minecraft:elytra", "minecraft:fishing_rod", "minecraft:flint_and_steel", "minecraft:golden_axe", "minecraft:golden_boots", "minecraft:golden_chestplate", "minecraft:golden_helmet", "minecraft:golden_hoe", "minecraft:golden_leggings", "minecraft:golden_pickaxe", "minecraft:golden_shovel", "minecraft:golden_sword", "minecraft:iron_axe", "minecraft:iron_boots", "minecraft:iron_chestplate", "minecraft:iron_helmet", "minecraft:iron_hoe", "minecraft:iron_leggings", "minecraft:iron_pickaxe", "minecraft:iron_shovel", "minecraft:iron_sword", "minecraft:leather_boots", "minecraft:leather_chestplate", "minecraft:leather_helmet", "minecraft:leather_leggings", "minecraft:shears", "minecraft:shield", "minecraft:stone_axe", "minecraft:stone_hoe", "minecraft:stone_pickaxe", "minecraft:stone_shovel", "minecraft:stone_sword", "minecraft:wooden_axe", "minecraft:wooden_hoe", "minecraft:wooden_pickaxe", "minecraft:wooden_shovel", "minecraft:wooden_sword");
    private final Cache<String, String> cache;
    private final Object defaultMaterial;

    public IMaterialMirror() {
        this(3L, TimeUnit.HOURS, "minecraft:paper");
    }

    public IMaterialMirror(long duration, TimeUnit unit, String defaultMaterial) {
        Object tag;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(duration, unit).build();
        try {
            tag = TagBase.newTag(ItemMaterialTag.SERVER_VALUES.containsKey(defaultMaterial) ? defaultMaterial : "minecraft:paper");
        }
        catch (Throwable t) {
            tag = null;
        }
        this.defaultMaterial = tag;
    }

    @Override
    public void upgrade(Object compound, String id, float from, float to) {
        this.resolveMaterial(compound, id, this.getDamage(compound, null, from), null, from, to);
    }

    @Override
    public void upgrade(Object compound, String id, Object components, float from, float to) {
        this.resolveSaved(compound, id, this.getDamage(compound, components, from), components, from, to);
    }

    @Override
    public void downgrade(Object compound, String id, float from, float to) {
        if (from >= 9.0f && to < 9.0f && (id.equals("minecraft:potion") || id.equals("minecraft:splash_potion"))) {
            return;
        }
        this.resolveMaterial(compound, id, this.getDamage(compound, null, from), null, from, to);
    }

    @Override
    public void downgrade(Object compound, String id, Object components, float from, float to) {
        if (from >= 9.0f && to < 9.0f && (id.equals("minecraft:potion") || id.equals("minecraft:splash_potion"))) {
            return;
        }
        this.resolveSaved(compound, id, this.getDamage(compound, components, from), components, from, to);
    }

    public void resolveSaved(Object compound, String id, int damage, Object components, float from, float to) {
        String savedID = IMaterialMirror.getSavedId(components, from, to);
        if (savedID != null) {
            String[] split;
            Object material = this.translate(savedID, from, to);
            if (((String)material).equals("null") && (split = savedID.split(":", 3)).length > 2 && !((String)(material = this.translate(savedID.substring(0, savedID.lastIndexOf(58)), from, to))).equals("null") && from >= 13.0f && to >= 13.0f) {
                material = (String)material + ":" + split[2];
            }
            if (!((String)material).equals("null")) {
                this.resolveItem(compound, (String)material, components, from, to);
                IMaterialMirror.setSavedId(compound, null, from, to);
            }
        } else {
            this.resolveMaterial(compound, id, damage, components, from, to);
        }
    }

    public void resolveMaterial(Object compound, String id, int damage, Object components, float from, float to) {
        String newMaterial;
        boolean saveDamage;
        boolean isEgg = from < 13.0f && from >= 9.0f && id.equalsIgnoreCase("minecraft:spawn_egg");
        boolean bl = saveDamage = from >= 13.0f || DAMAGEABLE.contains(id.toLowerCase());
        String material = isEgg ? id + "=" + this.getEggEntity(compound, from) : id + (String)(!saveDamage && damage > 0 ? ":" + damage : "");
        if (!material.equals(newMaterial = this.translate(material, from, to))) {
            if (isEgg && (to >= 13.0f || to < 9.0f)) {
                TagCompound.remove(compound, "EntityTag");
            }
            if (newMaterial.equals("null")) {
                TagCompound.set(compound, "id", this.defaultMaterial);
                IMaterialMirror.setSavedId(compound, material, from, to);
                this.setDamage(compound, components, 0, from, to);
                return;
            }
            this.resolveItem(compound, newMaterial, components, from, to);
        }
        if (saveDamage && damage > 0) {
            this.setDamage(compound, components, damage, from, to);
        }
    }

    public void resolveItem(Object compound, String material, Object components, float from, float to) {
        Object id;
        if (material.startsWith("minecraft:spawn_egg=")) {
            String[] split = material.split("=", 2);
            id = split[0];
            Rtag.INSTANCE.set(compound, split[1], "EntityTag", "id");
        } else {
            String[] split = material.split(":", 3);
            id = split[0] + ":" + split[1];
            try {
                this.setDamage(compound, components, split.length > 2 ? Integer.parseInt(split[2]) : 0, from, to);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        TagCompound.set(compound, "id", TagBase.newTag(id));
    }

    public void setDamage(Object compound, Object components, int damage, float from, float to) {
        if (from >= 20.04f && to >= 20.04f) {
            TagCompound.set(components, "minecraft:damage", TagBase.newTag(damage));
        } else if (to >= 13.0f) {
            if (from < 13.0f) {
                TagCompound.remove(compound, "Damage");
            }
            Rtag.INSTANCE.set(compound, damage, "tag", "Damage");
        } else {
            if (components != null && from >= 13.0f) {
                TagCompound.remove(components, "Damage");
            }
            TagCompound.set(compound, "Damage", TagBase.newTag((short)damage));
        }
    }

    private static void setSavedId(Object compound, String savedID, float from, float to) {
        if (from >= 20.04f && to >= 20.04f) {
            Rtag.INSTANCE.set(compound, savedID, "components", "minecraft:custom_data", SAVED_ID);
        } else {
            Rtag.INSTANCE.set(compound, savedID, "tag", SAVED_ID);
        }
    }

    public int getDamage(Object compound, Object components, float version) {
        Object damage = version >= 20.04f ? (components == null ? null : TagCompound.get(components, "minecraft:damage")) : (version >= 13.0f ? (components == null ? null : TagCompound.get(components, "Damage")) : TagCompound.get(compound, "Damage"));
        if ((damage = TagBase.getValue(damage)) != null) {
            if (damage instanceof Number) {
                return ((Number)damage).intValue();
            }
            try {
                return Integer.parseInt(String.valueOf(damage));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static String getSavedId(Object components, float from, float to) {
        Object savedId = from >= 20.04f && to >= 20.04f ? Rtag.INSTANCE.getExact(components, "minecraft:custom_data", SAVED_ID) : TagCompound.get(components, SAVED_ID);
        return (String)TagBase.getValue(savedId);
    }

    public String getEggEntity(Object compound, float version) {
        String entity = (String)Rtag.INSTANCE.get(compound, "EntityTag", "id");
        if (entity != null) {
            return entity;
        }
        if (version >= 12.0f) {
            return "pig";
        }
        if (version >= 11.0f) {
            return "minecraft:pig";
        }
        return "Pig";
    }

    public String translate(String material, float from, float to) {
        String mat = (String)this.cache.getIfPresent((Object)material);
        if (mat == null) {
            if (ItemMaterialTag.SERVER_VALUES.containsKey(material)) {
                this.cache.put((Object)material, (Object)material);
            } else {
                this.compute(material, ItemMaterialTag.changeNameCase(material.replace("minecraft:", ""), true), from, to);
            }
            mat = (String)this.cache.getIfPresent((Object)material);
        }
        return mat;
    }

    private void compute(String key, String value, float from, float to) {
        for (ItemMaterialTag tag : ItemMaterialTag.SERVER_VALUES.values()) {
            TreeMap<Float, String> names = tag.getNames();
            for (Float tagVersion : names.descendingKeySet()) {
                String tagName;
                if (!(tagVersion.floatValue() <= from) || !(tagName = names.get(tagVersion)).equals(value)) continue;
                Map.Entry<Float, String> entry = names.floorEntry(Float.valueOf(to));
                if (entry == null) {
                    this.cache.put((Object)key, (Object)"null");
                } else {
                    this.cache.put((Object)key, (Object)("minecraft:" + ItemMaterialTag.changeNameCase(entry.getValue(), false)));
                }
                return;
            }
        }
        this.cache.put((Object)key, (Object)"null");
    }
}

