/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag.util;

import com.google.gson.Gson;
import com.saicone.rtag.util.IterableType;
import com.saicone.rtag.util.ThrowableFunction;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;

public class OptionalType
extends IterableType<Object> {
    public static final OptionalType EMPTY = new OptionalType(null);
    public static final Gson GSON = new Gson();
    private Object value;

    public static OptionalType of(Object value) {
        return value != null ? new OptionalType(value) : EMPTY;
    }

    public static <T> T cast(Object object) {
        try {
            return (T)object;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public OptionalType(Object value) {
        this.value = value;
    }

    @Override
    protected Object getIterable() {
        return this.value;
    }

    @Override
    protected void setIterable(Object value) {
        this.value = value;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean isInstance(Class<?> clazz) {
        return clazz.isInstance(this.value);
    }

    public boolean isNotInstance(Class<?> clazz) {
        return !this.isInstance(clazz);
    }

    public OptionalType first() {
        if (this.isIterable()) {
            Iterator iterator = this.iterator();
            return iterator.hasNext() ? OptionalType.of(iterator.next()) : EMPTY;
        }
        return this;
    }

    public OptionalType single() {
        if (this.isIterable()) {
            Iterator iterator = this.iterator();
            return iterator.hasNext() ? OptionalType.of(iterator.next()).single() : EMPTY;
        }
        return this;
    }

    public <T> T value() {
        return OptionalType.cast(this.value);
    }

    public <T> T value(Class<T> clazz) {
        return (T)(this.isInstance(clazz) ? this.value : null);
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean deep) {
        if (this.value == null) {
            return;
        }
        this.clear(this.value, deep);
    }

    private void clear(Object object, boolean deep) {
        if (object instanceof Iterable) {
            if (deep) {
                for (Object o : (Iterable)object) {
                    this.clear(o, true);
                }
            }
            if (object instanceof Collection) {
                ((Collection)object).clear();
            }
        } else if (object instanceof Map) {
            if (deep) {
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    this.clear(entry.getValue(), true);
                    this.clear(entry.getKey(), true);
                }
            }
            ((Map)object).clear();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionalType objects = (OptionalType)o;
        return Objects.equals(this.value, objects.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public <T> T or(T def) {
        T value = this.value();
        return value != null ? value : def;
    }

    public <T> T or(Class<T> clazz, T def) {
        return (T)(this.isInstance(clazz) ? this.value : def);
    }

    public <T> T by(ThrowableFunction<Object, T> function) {
        try {
            return function.apply(this.value);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public <T> T by(ThrowableFunction<Object, T> function, T def) {
        T obj;
        if (this.value == null) {
            return def;
        }
        try {
            obj = function.apply(this.value);
        }
        catch (Throwable t) {
            return def;
        }
        return obj != null ? obj : def;
    }

    public <T> T by(Class<T> type, ThrowableFunction<Object, T> function, T def) {
        if (type.isInstance(this.value)) {
            return (T)this.value;
        }
        if (this.value instanceof Boolean && Number.class.isAssignableFrom(type)) {
            return (T)this.by(object -> function.apply(Boolean.TRUE.equals(object) ? "1" : "0"), def);
        }
        return this.by(function, def);
    }

    public <T> T as(Type type) {
        return (T)GSON.fromJson(GSON.toJsonTree(this.value), type);
    }

    public <T> T as(Class<T> type) {
        return (T)GSON.fromJson(GSON.toJsonTree(this.value), type);
    }

    public <T> T[] asArray(T[] array, Function<OptionalType, T> function) {
        if (this.value == null) {
            return array;
        }
        try {
            return (Object[])this.value;
        }
        catch (ClassCastException classCastException) {
            return this.asList(function).toArray(array);
        }
    }

    public <T> List<T> asList(Function<OptionalType, T> function) {
        return this.asCollection(new ArrayList(), function);
    }

    public <T, C extends Collection<T>> C asCollection(C collection, Function<OptionalType, T> function) {
        if (this.value == null) {
            return collection;
        }
        try {
            return (C)((Collection)this.value);
        }
        catch (ClassCastException classCastException) {
            if (this.isIterable()) {
                this.forEach(object -> {
                    Object result = function.apply(OptionalType.of(object));
                    if (result != null) {
                        collection.add(result);
                    }
                });
            } else {
                T result = function.apply(this);
                if (result != null) {
                    collection.add(result);
                }
            }
            return collection;
        }
    }

    public Object asObject() {
        return this.asObject(null);
    }

    public Object asObject(Object def) {
        return this.value != null ? this.value : def;
    }

    public String asString() {
        return this.asString(null);
    }

    public String asString(String def) {
        return this.value != null ? String.valueOf(this.value) : def;
    }

    public Character asChar() {
        return this.asChar(null);
    }

    public Character asChar(Character def) {
        return this.by(Character.class, object -> {
            String s = String.valueOf(object);
            return s.isBlank() ? null : Character.valueOf(s.charAt(0));
        }, def);
    }

    public Boolean asBoolean() {
        return this.asBoolean(null);
    }

    public Boolean asBoolean(Boolean def) {
        return this.by(Boolean.class, object -> {
            switch (String.valueOf(object).toLowerCase()) {
                case "true": 
                case "1": 
                case "1.0": 
                case "yes": 
                case "on": 
                case "y": {
                    return true;
                }
                case "false": 
                case "0": 
                case "0.0": 
                case "no": 
                case "off": 
                case "n": {
                    return false;
                }
            }
            return null;
        }, def);
    }

    public Byte asByte() {
        return this.asByte(null);
    }

    public Byte asByte(Byte def) {
        return this.by(Byte.class, object -> object instanceof Number ? ((Number)object).byteValue() : Byte.parseByte(String.valueOf(object)), def);
    }

    public Short asShort() {
        return this.asShort(null);
    }

    public Short asShort(Short def) {
        return this.by(Short.class, object -> object instanceof Number ? ((Number)object).shortValue() : Short.parseShort(String.valueOf(object)), def);
    }

    public Integer asInt() {
        return this.asInt(null);
    }

    public Integer asInt(Integer def) {
        return this.by(Integer.class, object -> object instanceof Number ? ((Number)object).intValue() : Integer.parseInt(String.valueOf(object)), def);
    }

    public Float asFloat() {
        return this.asFloat(null);
    }

    public Float asFloat(Float def) {
        return this.by(Float.class, object -> Float.valueOf(object instanceof Number ? ((Number)object).floatValue() : Float.parseFloat(String.valueOf(object))), def);
    }

    public Long asLong() {
        return this.asLong(null);
    }

    public Long asLong(Long def) {
        return this.by(Long.class, object -> object instanceof Number ? ((Number)object).longValue() : Long.parseLong(String.valueOf(object)), def);
    }

    public Double asDouble() {
        return this.asDouble(null);
    }

    public Double asDouble(Double def) {
        return this.by(Double.class, object -> object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble(String.valueOf(object)), def);
    }

    public UUID asUuid() {
        return this.asUuid(null);
    }

    public UUID asUuid(UUID def) {
        return this.by(UUID.class, object -> {
            if (object instanceof int[]) {
                return OptionalType.getUUID((int[])object);
            }
            if (object instanceof String) {
                return UUID.fromString((String)object);
            }
            return null;
        }, def);
    }

    public <E extends Enum<E>> E asEnum(Class<E> enumType) {
        return this.asEnum(enumType, null);
    }

    public <E extends Enum<E>> E asEnum(Class<E> enumType, E def) {
        return (E)this.by(enumType, object -> {
            if (object instanceof String) {
                String name = String.valueOf(object);
                for (Enum value : (Enum[])enumType.getEnumConstants()) {
                    if (!value.name().equalsIgnoreCase(name)) continue;
                    return value;
                }
                return null;
            }
            if (object instanceof Number) {
                int ordinal = ((Number)object).intValue();
                return ((Enum[])enumType.getEnumConstants())[ordinal];
            }
            return null;
        }, def);
    }

    public <E extends Enum<E>> Set<E> asEnumSet(Class<E> enumType) {
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        return this.asElementSet(ordinal -> ordinal < constants.length ? constants[ordinal] : null, constants.length);
    }

    public <E> Set<E> asElementSet(Function<Integer, E> element, int size) {
        HashSet<E> set = new HashSet<E>();
        for (Integer ordinal : this.asOrdinalSet(size)) {
            E e = element.apply(ordinal);
            if (e == null) continue;
            set.add(e);
        }
        return set;
    }

    public Set<Integer> asOrdinalSet(int size) {
        HashSet<Integer> ordinals = new HashSet<Integer>();
        Integer bitField = this.asInt();
        if (bitField == null) {
            return ordinals;
        }
        for (int i = 0; i < size; ++i) {
            byte bit = (byte)(1 << i);
            if ((bitField & bit) != bit) continue;
            ordinals.add(i);
        }
        return ordinals;
    }

    private static UUID getUUID(int[] array) {
        if (array.length == 4) {
            StringBuilder builder = new StringBuilder();
            for (int i : array) {
                String hex = Integer.toHexString(i);
                builder.append(new String(new char[8 - hex.length()]).replace('\u0000', '0')).append(hex);
            }
            if (builder.length() == 32) {
                builder.insert(20, '-').insert(16, '-').insert(12, '-').insert(8, '-');
                return UUID.fromString(builder.toString());
            }
            throw new IllegalArgumentException("The final converted UUID '" + builder + "' doesn't is a 32-length string");
        }
        throw new IllegalArgumentException("The provided int array isn't a 4-length array");
    }
}

