/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.arguments.basic;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.CompletionStyle;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.cwutils.numbers.NumbersUtils;

public class IntegerArg
extends Argument {
    int min = Integer.MIN_VALUE;
    int max = Integer.MAX_VALUE;
    CompletionStyle style = CompletionStyle.PLACEHOLDER;
    String placeholder = CommandsAPI.l10n.get("argument.integer.placeholder", new Object[0]);

    public IntegerArg() {
    }

    public IntegerArg(String placeholder) {
        this.placeholder = placeholder;
    }

    public IntegerArg setMin(int min) {
        this.min = min;
        return this;
    }

    public IntegerArg setMax(int max) {
        this.max = max;
        return this;
    }

    public IntegerArg setStyle(CompletionStyle style) {
        this.style = style;
        return this;
    }

    public IntegerArg setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    @Override
    public boolean valid(String raw) {
        try {
            if (!NumbersUtils.isInteger(raw)) {
                return false;
            }
            int parsed = Integer.parseInt(raw);
            return parsed >= this.min && parsed < this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public List<String> completions(Sender sender) {
        switch (this.style) {
            case PLACEHOLDER: {
                return Collections.singletonList(this.placeholder);
            }
            case DIAPASON: {
                return Collections.singletonList(this.min + " -> " + this.max);
            }
            case LIST: {
                return IntStream.range(this.min, this.max).limit(1000L).mapToObj(Integer::toString).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String argumentName() {
        return this.placeholder;
    }

    @Override
    public Object map() {
        return this.toInt();
    }

    @Override
    protected String hint() {
        boolean maxFlag;
        boolean minFlag = this.min > Integer.MIN_VALUE;
        boolean bl = maxFlag = this.max < Integer.MAX_VALUE;
        if (minFlag && maxFlag) {
            return CommandsAPI.l10n.get("argument.integer.hint.minmax", this.min, this.max);
        }
        if (!minFlag && maxFlag) {
            return CommandsAPI.l10n.get("argument.integer.hint.max", this.max);
        }
        if (minFlag && !maxFlag) {
            return CommandsAPI.l10n.get("argument.integer.hint.min", this.min);
        }
        return this.placeholder;
    }
}

