/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.paperplatform.argument;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Sender;

public class NearPlayersArg
extends Argument {
    int radius;
    int limit;

    public NearPlayersArg(int radius, int limit) {
        this.radius = radius;
        this.limit = limit;
    }

    @Override
    public boolean valid(String raw) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).anyMatch(x -> x.equalsIgnoreCase(raw));
    }

    public List<String> completions(Sender sender) {
        ArrayList<Player> players = new ArrayList<Player>();
        if (sender instanceof Player) {
            Player completeFor = (Player)sender;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (this.radius > 0 && (!(completeFor.getLocation().distance(player.getLocation()) < (double)this.radius) || player.equals((Object)completeFor))) continue;
                players.add(player);
            }
            players.sort(Comparator.comparingDouble(x -> x.getLocation().distance(completeFor.getLocation())));
        } else {
            players = new ArrayList(Bukkit.getOnlinePlayers());
        }
        ArrayList<String> list = new ArrayList<String>();
        long limit1 = this.limit <= 0 ? Integer.MAX_VALUE : (long)this.limit;
        for (Player player : players) {
            if (limit1-- == 0L) break;
            list.add(player.getName());
        }
        return list;
    }

    @Override
    public String argumentName() {
        return CommandsAPI.l10n.get("argument.nearPlayer.name", new Object[0]);
    }

    @Override
    public Object map() {
        return Bukkit.getPlayer((String)this.raw);
    }
}

