/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.collections;

import java.time.Duration;
import java.util.HashMap;
import java.util.Set;
import ru.cwcode.cwutils.datetime.Expireable;

public class ExpiredSet<Element> {
    protected final HashMap<Element, Expireable> expired = new HashMap();

    public void setExpired(Element element, Duration duration) {
        this.expired.put(element, new Expireable(duration.toMillis(), System.currentTimeMillis()));
    }

    public boolean isActive(Element element) {
        return this.getStatus(element).equals((Object)Status.ACTIVE);
    }

    public Status getStatus(Element element) {
        Expireable expireable = this.expired.get(element);
        if (expireable == null) {
            return Status.NO_ELEMENT;
        }
        return expireable.isExpired() ? Status.EXPIRED : Status.ACTIVE;
    }

    public double getPercent(Element element) {
        Expireable expireable = this.expired.get(element);
        if (expireable == null) {
            return -1.0;
        }
        return expireable.getPercent();
    }

    public boolean has(Element expired) {
        return this.expired.containsKey(expired);
    }

    public Set<Element> getExpired() {
        return this.expired.keySet();
    }

    public HashMap<Element, Expireable> entries() {
        return this.expired;
    }

    public static enum Status {
        ACTIVE,
        EXPIRED,
        NO_ELEMENT;

    }
}

