/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.entity;

import java.util.concurrent.ExecutionException;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.cwcode.cwutils.messages.Message;

public class Hologram {
    public static ArmorStand showText(Component text, int ticksToRemove, Location loc, JavaPlugin plugin) {
        if (Bukkit.isPrimaryThread()) {
            return Hologram.spawnHologram(text, ticksToRemove, loc, plugin);
        }
        try {
            return (ArmorStand)Bukkit.getScheduler().callSyncMethod((Plugin)plugin, () -> Hologram.spawnHologram(text, ticksToRemove, loc, plugin)).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            plugin.getLogger().warning(exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public static ArmorStand showText(String text, int ticksToRemove, Location loc, JavaPlugin plugin) {
        return Hologram.showText(Message.from(text), ticksToRemove, loc, plugin);
    }

    private static ArmorStand spawnHologram(Component text, int ticksToRemove, Location loc, JavaPlugin plugin) {
        return (ArmorStand)loc.getWorld().spawn(loc, ArmorStand.class, armorStand -> {
            armorStand.setVisible(false);
            armorStand.customName(text);
            armorStand.setCustomNameVisible(true);
            armorStand.setMarker(true);
            armorStand.setCanMove(false);
            armorStand.addScoreboardTag("hologram");
            armorStand.setCanTick(false);
            if (ticksToRemove > 0) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> ((ArmorStand)armorStand).remove(), (long)ticksToRemove);
            }
        });
    }
}

