/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.items;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemBuilder {
    protected ItemStack item;
    protected ItemMeta meta;

    public ItemBuilder(Material material) {
        this.item = new ItemStack(material);
        this.meta = this.item.getItemMeta();
    }

    public ItemBuilder(ItemStack item) {
        this.item = item;
        if (item != null) {
            this.meta = item.getItemMeta();
        }
    }

    public static ItemBuilder of(Material material) {
        return new ItemBuilder(material);
    }

    public static ItemBuilder of(ItemStack item) {
        return new ItemBuilder(item);
    }

    public ItemBuilder amount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public Component name() {
        if (!this.hasName()) {
            return Component.translatable(this.item.getType().getTranslationKey()).decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE);
        }
        return this.meta.displayName();
    }

    public boolean hasName() {
        return this.meta != null && this.meta.hasDisplayName();
    }

    public ItemBuilder name(Component name) {
        this.meta.displayName(name.decoration(TextDecoration.ITALIC, false));
        return this;
    }

    public List<Component> description() {
        return this.item.lore() == null ? List.of() : this.item.lore();
    }

    public boolean hasDescription() {
        return this.item.lore() != null;
    }

    public ItemBuilder description(Component ... description) {
        return this.description(Arrays.asList(description));
    }

    public ItemBuilder description(List<Component> description) {
        this.meta.lore(description.stream().map(x -> x.decoration(TextDecoration.ITALIC, false)).toList());
        return this;
    }

    public ItemBuilder model(int customModelData) {
        this.meta.setCustomModelData(Integer.valueOf(customModelData));
        return this;
    }

    public ItemBuilder unbreakable() {
        return this.unbreakable(true);
    }

    public ItemBuilder unbreakable(boolean value) {
        this.meta.setUnbreakable(value);
        return this;
    }

    public ItemBuilder flags(ItemFlag ... flags) {
        this.meta.addItemFlags(flags);
        return this;
    }

    public ItemBuilder damage(double damage) {
        return this.setAttribute(Attribute.GENERIC_ATTACK_DAMAGE, damage);
    }

    public ItemBuilder setAttribute(Attribute attribute, double value) {
        this.meta.removeAttributeModifier(attribute);
        this.meta.addAttributeModifier(attribute, new AttributeModifier(UUID.randomUUID(), attribute.name(), value - 1.0, AttributeModifier.Operation.ADD_NUMBER, this.item.getType().getEquipmentSlot()));
        return this;
    }

    public ItemBuilder health(double health) {
        return this.setAttribute(Attribute.GENERIC_MAX_HEALTH, health);
    }

    public ItemBuilder knockbackResistance(double knockback) {
        return this.setAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE, knockback);
    }

    public ItemBuilder moveSpeed(double speed) {
        return this.setAttribute(Attribute.GENERIC_MOVEMENT_SPEED, speed);
    }

    public ItemBuilder attackSpeed(double speed) {
        return this.setAttribute(Attribute.GENERIC_ATTACK_SPEED, speed);
    }

    public ItemBuilder attackKnockback(double knockback) {
        return this.setAttribute(Attribute.GENERIC_ATTACK_SPEED, knockback);
    }

    public ItemBuilder multiplyAttribute(Attribute attribute, double value) {
        this.meta.addAttributeModifier(attribute, new AttributeModifier(UUID.randomUUID(), attribute.name(), value, AttributeModifier.Operation.MULTIPLY_SCALAR_1, this.item.getType().getEquipmentSlot()));
        return this;
    }

    public ItemBuilder enchantment(Enchantment enchantment, int level) {
        this.meta.addEnchant(enchantment, level, true);
        return this;
    }

    public ItemBuilder customEffect(PotionEffectType effect, int duration, int level) {
        return this.customEffect(new PotionEffect(effect, duration, level));
    }

    public ItemBuilder customEffect(PotionEffect effect) {
        if (this.isPotionMeta()) {
            ((PotionMeta)this.meta).addCustomEffect(effect, true);
        }
        return this;
    }

    public boolean isPotionMeta() {
        return this.meta instanceof PotionMeta;
    }

    public ItemBuilder playerProfile(PlayerProfile profile) {
        if (this.isSkullMeta()) {
            ((SkullMeta)this.meta).setPlayerProfile(profile);
        }
        return this;
    }

    public boolean isSkullMeta() {
        return this.meta instanceof SkullMeta;
    }

    public ItemBuilder customModelData(int data) {
        return this.model(data);
    }

    public ItemBuilder tag(NamespacedKey key, String value) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)value);
        return this;
    }

    public ItemBuilder tag(NamespacedKey key, int value) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)value);
        return this;
    }

    public ItemBuilder tag(NamespacedKey key, double value) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.DOUBLE, (Object)value);
        return this;
    }

    public ItemBuilder tag(NamespacedKey key, long value) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.LONG, (Object)value);
        return this;
    }

    public ItemBuilder type(Material material) {
        this.item.setType(material);
        return this;
    }

    public ItemBuilder setCanPlace(Collection<Material> blocks) {
        this.meta.setPlaceableKeys((Collection)blocks.stream().map(Material::getKey).collect(Collectors.toSet()));
        return this;
    }

    public ItemStack build() {
        return this.generateItem();
    }

    protected ItemStack generateItem() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }
}

