/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.persistent;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class PersistentWrapper {
    private static final Gson gson = new Gson();
    PersistentDataContainer container;
    List<PersistentField<?, ?>> fields = new ArrayList(3);

    public PersistentWrapper(PersistentDataContainer container) {
        this.container = container;
    }

    public PersistentWrapper(PersistentDataHolder holder) {
        this.container = holder.getPersistentDataContainer();
    }

    public void clear() {
        this.fields.forEach(PersistentField::remove);
    }

    public Map<NamespacedKey, Object> serialize() {
        return this.fields.stream().collect(Collectors.toMap(x -> x.key, PersistentField::getOrNull));
    }

    public String toString() {
        return gson.toJson(this.fields.stream().collect(Collectors.toMap(x -> x.key.toString(), PersistentField::getOrNull)));
    }

    protected <T, Z> PersistentField<T, Z> bind(PersistentDataType<T, Z> type, NamespacedKey key) {
        PersistentField<T, Z> field = new PersistentField<T, Z>(this, type, key);
        this.fields.add(field);
        return field;
    }

    protected <T, Z> PersistentField<T, Z> bind(PersistentDataType<T, Z> type, String namespacedKey) {
        return this.bind(type, NamespacedKey.fromString((String)namespacedKey));
    }

    public static class PersistentField<T, Z> {
        private final PersistentWrapper wrapper;
        private final PersistentDataType<T, Z> type;
        private final NamespacedKey key;

        public PersistentField(PersistentWrapper wrapper, PersistentDataType<T, Z> type, NamespacedKey key) {
            this.wrapper = wrapper;
            this.type = type;
            this.key = key;
        }

        public Z getOrNull() {
            return (Z)this.wrapper.container.get(this.key, this.type);
        }

        public Optional<Z> get() {
            return Optional.ofNullable(this.getOrNull());
        }

        public Optional<Z> set(Z value) {
            Optional<Z> previous = this.get();
            this.wrapper.container.set(this.key, this.type, value);
            return previous;
        }

        public Optional<Z> remove() {
            Optional<Z> previous = this.get();
            this.wrapper.container.remove(this.key);
            return previous;
        }
    }
}

