/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.player;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.util.WeakHashMap;
import org.bukkit.entity.Player;

public class WindowIdCatcher {
    static WeakHashMap<Player, Integer> windowIDs = new WeakHashMap();
    static boolean loaded = false;

    public static void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter(ProtocolLibrary.getPlugin(), new PacketType[]{PacketType.Play.Server.OPEN_WINDOW}){

            public void onPacketSending(PacketEvent event) {
                windowIDs.put(event.getPlayer(), (Integer)event.getPacket().getIntegers().read(0));
            }
        });
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter(ProtocolLibrary.getPlugin(), new PacketType[]{PacketType.Play.Client.CLOSE_WINDOW}){

            public void onPacketReceiving(PacketEvent event) {
                windowIDs.put(event.getPlayer(), 0);
            }
        });
    }

    public static int getWindowID(Player player) {
        return windowIDs.getOrDefault(player, 0);
    }
}

