/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.text;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class StringToObjectParser {
    static Map<Class<?>, Function<String, Object>> parsers = new HashMap();

    public static <T> void registerType(Class<T> clazz, Function<String, T> parser) {
        parsers.put(clazz, parser);
    }

    public static <T> T parse(String input, Class<T> clazz) {
        Function<String, Object> function = parsers.get(clazz);
        if (function == null) {
            return null;
        }
        return (T)function.apply(input);
    }

    static {
        StringToObjectParser.registerType(String.class, s -> s);
        StringToObjectParser.registerType(Integer.TYPE, Integer::parseInt);
        StringToObjectParser.registerType(Integer.class, Integer::parseInt);
        StringToObjectParser.registerType(Long.TYPE, Long::parseLong);
        StringToObjectParser.registerType(Long.class, Long::parseLong);
        StringToObjectParser.registerType(Float.TYPE, Float::parseFloat);
        StringToObjectParser.registerType(Float.class, Float::parseFloat);
        StringToObjectParser.registerType(Double.TYPE, Double::parseDouble);
        StringToObjectParser.registerType(Double.class, Double::parseDouble);
        StringToObjectParser.registerType(Boolean.TYPE, Boolean::parseBoolean);
        StringToObjectParser.registerType(Boolean.class, Boolean::parseBoolean);
    }
}

