/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.executor;

import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.ArgumentParser;
import ru.cwcode.commands.ArgumentSet;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.cwutils.collections.EnumUtils;
import ru.cwcode.cwutils.text.SpacesHider;

public abstract class AbstractExecutor {
    protected ArgumentParser parser;
    protected Sender sender;
    protected Command command = null;

    public void prepare(Sender sender, String[] args, ArgumentSet argumentSet, Command command) {
        this.parser = new ArgumentParser(args, argumentSet);
        this.sender = sender;
        this.command = command;
        try {
            if (sender.isPlayer()) {
                this.executeForPlayer();
            } else {
                this.executeForNonPlayer();
            }
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public abstract void executeForPlayer();

    public void executeForNonPlayer() {
        this.executeForPlayer();
    }

    public abstract void handleError(Exception var1);

    protected abstract Audience sender();

    public Argument arg(String tag) {
        return this.parser.get(tag);
    }

    protected final Optional<Argument> argO(int index) {
        if (this.isPresent(index)) {
            return Optional.of(this.arg(index));
        }
        return Optional.empty();
    }

    protected final Argument arg(int index) {
        return this.parser.get(index);
    }

    public boolean isPresent(int index) {
        return this.argumentsAmount() > index;
    }

    protected final int argumentsAmount() {
        return this.parser.args.length;
    }

    protected double argD(int index) {
        return this.arg(index).toDouble();
    }

    protected int argI(int index) {
        return this.arg(index).toInt();
    }

    protected String argS(int index) {
        return this.arg(index).toString();
    }

    protected boolean argB(int index) {
        return this.arg(index).toBoolean();
    }

    protected <T extends Enum<?>> Optional<T> argE(int index, Class<? extends T> enumClass) {
        try {
            return EnumUtils.getEnumInstance((Enum[])EnumUtils.getEnumValues(enumClass), (String)this.argS(index));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    protected abstract Optional<? extends Audience> argP(int var1);

    protected String argWithSpaces(int index) {
        return SpacesHider.restore(this.arg(index).toString());
    }

    protected Command getCommand() {
        return this.command;
    }
}

