/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.paperplatform.argument.location;

import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.paperplatform.argument.location.LocationPart;
import ru.cwcode.commands.paperplatform.paper.PaperSender;
import ru.cwcode.cwutils.numbers.NumbersUtils;

public class TargetXArg
extends Argument {
    private final LocationPart part;

    public TargetXArg(LocationPart part) {
        this.part = part;
    }

    @Override
    public boolean valid(String raw) {
        switch (this.part) {
            case X: 
            case Y: 
            case Z: {
                return NumbersUtils.isNumber(raw);
            }
            case PITCH: {
                float pitch = Float.parseFloat(raw);
                return NumbersUtils.isNumber(raw) && pitch >= -90.0f && pitch <= 90.0f;
            }
            case YAW: {
                float yaw = Float.parseFloat(raw);
                return NumbersUtils.isNumber(raw) && yaw >= 0.0f && yaw < 360.0f;
            }
            case WORLD: {
                return Bukkit.getWorld((String)raw) != null;
            }
        }
        return false;
    }

    public List<String> completions(Sender sender) {
        if (sender instanceof PaperSender) {
            Location targetLocation;
            Player player = ((PaperSender)sender).getPlayer();
            Block targetBlock = player.getTargetBlockExact(100);
            if (targetBlock == null) {
                targetLocation = player.getLocation();
            } else {
                targetLocation = targetBlock.getLocation();
                targetLocation.setYaw(player.getLocation().getYaw());
                targetLocation.setPitch(player.getLocation().getPitch());
            }
            return this.part.getSuggestion(targetLocation);
        }
        return Collections.singletonList(this.part.name());
    }

    @Override
    public String argumentName() {
        return this.part.name();
    }

    @Override
    public Object map() {
        switch (this.part) {
            case X: 
            case Y: 
            case Z: {
                return this.toDouble();
            }
            case PITCH: 
            case YAW: {
                return this.toFloat();
            }
            case WORLD: {
                return Bukkit.getWorld((String)this.part.name());
            }
        }
        throw new IllegalArgumentException("Unknown location part: " + String.valueOf((Object)this.part));
    }
}

