/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.collections.indexList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.cwutils.collections.indexList.Index;

public class IndexList<E>
implements List<E> {
    List<E> elements;
    List<Index<?, E>> indexes = new ArrayList();

    public IndexList(List<E> elements) {
        this.elements = elements;
    }

    public void registerIndex(@NotNull Index<?, E> index) {
        this.indexes.add(index);
    }

    @Override
    public boolean add(E element) {
        this.elements.add(element);
        this.notifyAdd(element);
        return true;
    }

    @Override
    public E remove(int index) {
        E removed = this.elements.remove(index);
        this.notifyRemove(removed);
        return removed;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.elements.remove(o);
        this.notifyRemove(o);
        return removed;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        boolean added = this.elements.addAll(c);
        for (E e : c) {
            this.notifyAdd(e);
        }
        return added;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> c) {
        boolean added = this.elements.addAll(index, c);
        for (E e : c) {
            this.notifyAdd(e);
        }
        return added;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean removed = this.elements.removeAll(c);
        for (Object e : c) {
            this.notifyRemove(e);
        }
        return removed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<? super E> c) {
        this.elements.sort(c);
    }

    @Override
    public void clear() {
        for (E e : this.elements) {
            this.notifyRemove(e);
        }
        this.elements.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.elements.equals(o);
    }

    @Override
    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public E get(int index) {
        return this.elements.get(index);
    }

    @Override
    public E set(int index, E element) {
        E previous = this.elements.set(index, element);
        this.notifyRemove(previous);
        this.notifyAdd(element);
        return previous;
    }

    @Override
    public void add(int index, E element) {
        this.elements.add(index, element);
        this.notifyAdd(element);
    }

    @Override
    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.elements.lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return this.elements.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        return this.elements.listIterator(index);
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.elements.spliterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.elements.forEach(action);
    }

    @Override
    public Stream<E> parallelStream() {
        return this.elements.parallelStream();
    }

    @Override
    public Stream<E> stream() {
        return this.elements.stream();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        for (E element : this.elements) {
            if (!filter.test(element)) continue;
            this.notifyRemove(element);
        }
        return this.elements.removeIf(filter);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.elements.toArray(generator);
    }

    protected void notifyRemove(E removed) {
        for (Index<?, E> index : this.indexes) {
            index.onElementRemoved(removed);
        }
    }

    protected void notifyAdd(E element) {
        for (Index<?, E> index : this.indexes) {
            index.onElementAdded(element);
        }
    }
}

