/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.dependencyChecker;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import ru.cwcode.cwutils.dependencyChecker.DependencyListener;
import ru.cwcode.cwutils.dependencyChecker.DependencyListeners;
import ru.cwcode.cwutils.dependencyChecker.PluginRequirement;
import ru.cwcode.cwutils.dependencyChecker.UnsatisfiedDependencyException;

public class DependencyChecker {
    List<PluginRequirement> requirements = new ArrayList<PluginRequirement>();
    DependencyListeners listeners = new DependencyListeners();

    public DependencyChecker addDependency(String pluginId, Consumer<PluginRequirement.PluginRequirementBuilder> builder) {
        PluginRequirement.PluginRequirementBuilder requirementBuilder = PluginRequirement.of(pluginId);
        builder.accept(requirementBuilder);
        this.requirements.add(requirementBuilder.build());
        return this;
    }

    public DependencyChecker addListener(DependencyListener listener) {
        this.listeners.addDependencyListener(listener);
        return this;
    }

    public void handleDependencies() {
        this.requirements.stream().peek(x -> {
            Optional<Plugin> requiredPlugin = x.getRequiredPlugin();
            if (!x.isOptional() && requiredPlugin.isEmpty()) {
                throw new UnsatisfiedDependencyException((PluginRequirement)x);
            }
        }).forEach(requirement -> {
            Optional<Plugin> requiredPlugin = requirement.getRequiredPlugin();
            requirement.adaptPlugin(requiredPlugin.orElse(null)).ifPresent(adapter -> this.listeners.handleAdapter(requirement.getRequirementAdapter().getAdapterClass(), adapter));
        });
    }
}

