/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.dependencyChecker;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.cwcode.cwutils.dependencyChecker.RequirementAdapter;
import ru.cwcode.cwutils.server.ServerUtils;

public class PluginRequirement {
    private final String pluginId;
    private final String versionMin;
    private final String versionMax;
    private final boolean optional;
    private final RequirementAdapter<?> requirementAdapter;

    PluginRequirement(String pluginId, String versionMin, String versionMax, boolean optional, @Nullable RequirementAdapter<?> requirementAdapter) {
        this.pluginId = pluginId;
        this.versionMin = versionMin;
        this.versionMax = versionMax;
        this.optional = optional;
        this.requirementAdapter = requirementAdapter;
    }

    public static PluginRequirementBuilder of(String pluginId) {
        return new PluginRequirementBuilder(pluginId);
    }

    public String toString() {
        return "PluginRequirement{pluginId='" + this.pluginId + "', versionMin='" + this.versionMin + "', versionMax='" + this.versionMax + "', optional=" + this.optional + "}";
    }

    public Optional<Plugin> getRequiredPlugin() {
        return Optional.ofNullable(Bukkit.getPluginManager().getPlugin(this.pluginId)).filter(this::isVersionAcceptable);
    }

    public String getProvidedVersion() {
        return this.getPlugin().map(x -> x.getDescription().getVersion()).orElse("absent");
    }

    public Optional<Object> adaptPlugin(Plugin plugin) {
        if (this.requirementAdapter == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.requirementAdapter.adapt(plugin));
    }

    public int versionMinNum() {
        return ServerUtils.getVersionWeight(this.versionMin);
    }

    public int versionMaxNum() {
        return ServerUtils.getVersionWeight(this.versionMax);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public RequirementAdapter<?> getRequirementAdapter() {
        return this.requirementAdapter;
    }

    @NotNull
    private Optional<Plugin> getPlugin() {
        return Optional.ofNullable(Bukkit.getPluginManager().getPlugin(this.pluginId));
    }

    private boolean isVersionAcceptable(Plugin plugin) {
        int currentVersion = ServerUtils.getVersionWeight(plugin.getDescription().getVersion());
        return !(this.versionMinNum() != 0 && currentVersion < this.versionMinNum() || this.versionMaxNum() != 0 && currentVersion > this.versionMaxNum());
    }

    public static class PluginRequirementBuilder {
        private final String pluginId;
        private String versionMin = "any";
        private String versionMax = "any";
        private boolean optional = false;
        private RequirementAdapter<?> requirementAdapter;

        PluginRequirementBuilder(String pluginId) {
            this.pluginId = pluginId;
        }

        public PluginRequirementBuilder versionMin(String versionMin) {
            this.versionMin = versionMin;
            return this;
        }

        public PluginRequirementBuilder versionMax(String versionMax) {
            this.versionMax = versionMax;
            return this;
        }

        public PluginRequirementBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public PluginRequirementBuilder optional() {
            return this.optional(true);
        }

        public <T> PluginRequirementBuilder adapter(Class<T> clazz, Function<Plugin, T> adapter, Supplier<T> absentPluginAdapter) {
            this.requirementAdapter = new RequirementAdapter<T>(clazz, adapter, absentPluginAdapter);
            return this;
        }

        public <T> PluginRequirementBuilder adapter(Class<T> clazz, Function<Plugin, T> adapter) {
            this.requirementAdapter = new RequirementAdapter<Object>(clazz, adapter, () -> {
                throw new NoSuchElementException(String.format("Plugin %s is required", this.pluginId));
            });
            return this;
        }

        public PluginRequirement build() {
            return new PluginRequirement(this.pluginId, this.versionMin, this.versionMax, this.optional, this.requirementAdapter);
        }
    }
}

