/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.l10n;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.cwutils.collections.CollectionUtils;
import ru.cwcode.cwutils.l10n.L10nPlatform;
import ru.cwcode.cwutils.l10n.LocalizationRepository;
import ru.cwcode.cwutils.l10n.PluginLocalizationRepository;

public class L10n {
    private final L10nPlatform l10nPlatform;
    LocalizationRepository repository;
    String locale;

    public L10n(L10nPlatform l10nPlatform) {
        this.l10nPlatform = l10nPlatform;
        this.repository = new PluginLocalizationRepository(l10nPlatform);
        this.loadDefaultLocale();
    }

    public String get(String key, Object ... args) {
        String entry = this.repository.getEntry(this.getLocale(), key);
        if (entry == null) {
            return key + "[" + CollectionUtils.toString(args, "", ", ", true) + "]";
        }
        return String.format(entry, args);
    }

    @Blocking
    public void setLocale(String locale, boolean persist) {
        if (Locale.forLanguageTag(locale) == null) {
            this.l10nPlatform.getLogger().warn("Invalid locale: " + locale);
            return;
        }
        this.locale = locale;
        this.l10nPlatform.getLogger().info("Selected locale: " + locale);
        if (persist) {
            this.storeSelectedLocaleAtFile();
        }
    }

    public Set<String> getAvailableLocales() {
        return this.repository.getAvailableLocales();
    }

    private void loadDefaultLocale() {
        Properties selectedLocale = new Properties();
        try {
            File selectedLocaleFile = this.getSelectedLocaleFile();
            if (selectedLocaleFile.exists()) {
                selectedLocale.load(new InputStreamReader((InputStream)new FileInputStream(selectedLocaleFile), StandardCharsets.UTF_8));
                String locale = selectedLocale.getProperty("locale");
                if (locale != null) {
                    this.setLocale(locale, false);
                    return;
                }
            } else {
                this.l10nPlatform.getLogger().info("No selected locale file found. Using system locale.");
            }
        }
        catch (IOException e) {
            this.l10nPlatform.getLogger().warn("Cannot read selected locale file");
        }
        this.setLocale(Locale.getDefault().getLanguage(), true);
    }

    @NotNull
    private File getSelectedLocaleFile() {
        return this.localeDirectoryPath().resolve("selectedLocale.properties").toFile();
    }

    @NotNull
    private Path localeDirectoryPath() {
        return this.l10nPlatform.getDataDirectory().resolve("locale");
    }

    private void storeSelectedLocaleAtFile() {
        Properties selectedLocale = new Properties();
        selectedLocale.setProperty("locale", this.locale);
        this.localeDirectoryPath().toFile().mkdirs();
        try (FileWriter fileWriter = new FileWriter(this.getSelectedLocaleFile());){
            selectedLocale.store(fileWriter, "");
        }
        catch (IOException e) {
            this.l10nPlatform.getLogger().warn("Cannot write selected locale file");
            e.printStackTrace();
        }
    }

    public String getLocale() {
        return this.locale;
    }
}

