/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.reflection;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.plugin.java.JavaPlugin;
import ru.cwcode.cwutils.reflection.ReflectionUtils;

public class ClassScanner {
    File jar;
    List<ClassApplier> classAppliers = new ArrayList<ClassApplier>();
    List<MethodApplier> methodAppliers = new ArrayList<MethodApplier>();
    List<FieldApplier> fieldAppliers = new ArrayList<FieldApplier>();
    Predicate<String> filter = filter -> true;

    public ClassScanner(File jar) {
        this.jar = jar;
    }

    public ClassScanner apply(ClassApplier applier) {
        this.classAppliers.add(applier);
        return this;
    }

    public ClassScanner apply(MethodApplier applier) {
        this.methodAppliers.add(applier);
        return this;
    }

    public ClassScanner apply(FieldApplier applier) {
        this.fieldAppliers.add(applier);
        return this;
    }

    public ClassScanner classFilter(Predicate<String> filter) {
        this.filter = filter;
        return this;
    }

    public void scan(JavaPlugin plugin) {
        if (this.classAppliers.isEmpty() && this.methodAppliers.isEmpty() && this.fieldAppliers.isEmpty()) {
            return;
        }
        String packageName = plugin.getClass().getPackage().getName();
        int i = 0;
        long start = System.currentTimeMillis();
        try {
            for (Class<?> clazz : ReflectionUtils.getClasses(this.jar, packageName, this.filter)) {
                ++i;
                this.handle(clazz);
            }
            plugin.getLogger().info("Scanned " + i + " classes, took " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.classAppliers.clear();
        this.methodAppliers.clear();
        this.fieldAppliers.clear();
    }

    private void handle(Class<?> classInfo) throws ClassNotFoundException {
        for (ClassApplier classApplier : this.classAppliers) {
            if (!classApplier.predicate.test(classInfo)) continue;
            classApplier.consumer.accept(classInfo);
        }
        for (Method method : classInfo.getDeclaredMethods()) {
            for (MethodApplier methodApplier : this.methodAppliers) {
                if (!methodApplier.predicate.test(method)) continue;
                methodApplier.consumer.accept(method);
            }
        }
        for (AccessibleObject accessibleObject : classInfo.getDeclaredFields()) {
            for (FieldApplier fieldApplier : this.fieldAppliers) {
                if (!fieldApplier.predicate.test((Field)accessibleObject)) continue;
                fieldApplier.consumer.accept((Field)accessibleObject);
            }
        }
    }

    public static class ClassApplier {
        private final Predicate<Class<?>> predicate;
        private final Consumer<Class<?>> consumer;

        public ClassApplier(Predicate<Class<?>> predicate, Consumer<Class<?>> consumer) {
            this.predicate = predicate;
            this.consumer = consumer;
        }
    }

    public static class MethodApplier {
        private final Predicate<Method> predicate;
        private final Consumer<Method> consumer;

        public MethodApplier(Predicate<Method> predicate, Consumer<Method> consumer) {
            this.predicate = predicate;
            this.consumer = consumer;
        }
    }

    public static class FieldApplier {
        private final Predicate<Field> predicate;
        private final Consumer<Field> consumer;

        public FieldApplier(Predicate<Field> predicate, Consumer<Field> consumer) {
            this.predicate = predicate;
            this.consumer = consumer;
        }
    }
}

