/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.xp;

import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;

public class XpUtils {
    public static void dropExp(Location location, int xp) {
        ExperienceOrb orb = (ExperienceOrb)Objects.requireNonNull(location.getWorld()).spawnEntity(location, EntityType.EXPERIENCE_ORB);
        orb.setExperience(xp);
    }

    public static int getExp(Player player) {
        return XpUtils.getExpFromLevel(player.getLevel()) + Math.round((float)XpUtils.getExpToNext(player.getLevel()) * player.getExp());
    }

    public static int getExpFromLevel(int level) {
        if (level > 30) {
            return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        }
        if (level > 15) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return level * level + 6 * level;
    }

    public static double getLevelFromExp(long exp) {
        if (exp > 1395L) {
            return (Math.sqrt(72L * exp - 54215L) + 325.0) / 18.0;
        }
        if (exp > 315L) {
            return Math.sqrt(40L * exp - 7839L) / 10.0 + 8.1;
        }
        if (exp > 0L) {
            return Math.sqrt(exp + 9L) - 3.0;
        }
        return 0.0;
    }

    public static void changeExp(Player player, int exp) {
        if ((exp += XpUtils.getExp(player)) < 0) {
            exp = 0;
        }
        double levelAndExp = XpUtils.getLevelFromExp(exp);
        int level = (int)levelAndExp;
        player.setLevel(level);
        player.setExp((float)(levelAndExp - (double)level));
    }

    private static int getExpToNext(int level) {
        if (level > 30) {
            return 9 * level - 158;
        }
        if (level > 15) {
            return 5 * level - 38;
        }
        return 2 * level + 7;
    }
}

