/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.animation;

import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.cwcode.cwutils.animation.AnimationProperties;
import ru.cwcode.cwutils.animation.ExecutionMode;

public class SimpleAnimation {
    AnimationProperties properties;
    Consumer<Double> action;
    private Runnable before = null;
    private Runnable after = null;
    private boolean andBack = false;

    public SimpleAnimation setProperties(AnimationProperties properties) {
        this.properties = properties;
        return this;
    }

    public SimpleAnimation setAction(Consumer<Double> action) {
        this.action = action;
        return this;
    }

    public void start(JavaPlugin plugin, ExecutionMode mode) {
        this.runBefore(plugin, mode);
        this.runMain(plugin, mode);
        this.runAfter(plugin, mode);
    }

    public SimpleAnimation before(Runnable before) {
        this.before = before;
        return this;
    }

    public SimpleAnimation after(Runnable after) {
        this.after = after;
        return this;
    }

    public SimpleAnimation andBack() {
        this.andBack = true;
        return this;
    }

    private void runAfter(JavaPlugin plugin, ExecutionMode mode) {
        if (this.after == null) {
            return;
        }
        switch (mode) {
            case ASYNC: 
            case INSTANT_ASYNC: {
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, () -> this.after.run(), this.properties.frameDelayInTicks() + 1L);
                break;
            }
            case SYNC: 
            case INSTANT_SYNC: {
                Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> this.after.run(), this.properties.frameDelayInTicks() + 1L);
            }
        }
    }

    private void runMain(JavaPlugin plugin, ExecutionMode mode) {
        while (this.properties.hasNextFrame()) {
            double finalCurrent = this.properties.nextFrame();
            switch (mode) {
                case ASYNC: 
                case INSTANT_ASYNC: {
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, () -> this.action.accept(finalCurrent), this.properties.frameDelayInTicks());
                    if (!this.andBack) break;
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, () -> this.action.accept(finalCurrent), this.properties.lastFrameDelayInTicks() * 2L - this.properties.frameDelayInTicks());
                    break;
                }
                case SYNC: 
                case INSTANT_SYNC: {
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> this.action.accept(finalCurrent), this.properties.frameDelayInTicks());
                    if (!this.andBack) break;
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> this.action.accept(finalCurrent), this.properties.lastFrameDelayInTicks() * 2L - this.properties.frameDelayInTicks());
                }
            }
        }
    }

    private void runBefore(JavaPlugin plugin, ExecutionMode mode) {
        if (this.before == null) {
            return;
        }
        switch (mode) {
            case ASYNC: {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> this.before.run());
                break;
            }
            case SYNC: {
                Bukkit.getScheduler().runTask((Plugin)plugin, () -> this.before.run());
                break;
            }
            case INSTANT_ASYNC: 
            case INSTANT_SYNC: {
                this.before.run();
            }
        }
    }
}

