/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.cwcode.cwutils.numbers.Rand;

public class CollectionUtils {
    @Nullable
    public static <T> T getRandomListEntry(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.get(Rand.ofInt(list.size()));
    }

    @SafeVarargs
    public static <T> T getRandomArrayEntry(T ... values) {
        if (values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        return values[Rand.ofInt(values.length)];
    }

    @Deprecated
    public static void shuffleArray(int[] ar) {
        for (int i = ar.length - 1; i > 0; --i) {
            int index = Rand.ofInt(i + 1);
            int a = ar[index];
            ar[index] = ar[i];
            ar[i] = a;
        }
    }

    public static <T> T[] shuffleArray(T[] array) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = Rand.ofInt(i + 1);
            T a = array[index];
            array[index] = array[i];
            array[i] = a;
        }
        return array;
    }

    @SafeVarargs
    public static <T> Collection<T> combine(Collection<T> ... lists) {
        int size = 0;
        for (Collection<T> list : lists) {
            size += list.size();
        }
        ArrayList<T> combined = new ArrayList<T>(size);
        for (Collection<T> list : lists) {
            combined.addAll(list);
        }
        return combined;
    }

    public static <T> boolean containsAny(Collection<T> one, Collection<T> two) {
        for (T t : one) {
            if (!two.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean hasAllElements(Collection<T> toCheck, Collection<T> elements) {
        for (T t : elements) {
            if (toCheck.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static String toString(Object[] values) {
        return CollectionUtils.getStringOfArray(values);
    }

    @Deprecated(forRemoval=true)
    public static String getStringOfArray(Object[] values) {
        return CollectionUtils.toString(values, "\n - ", "", false);
    }

    public static String toString(Object[] values, String prefix, String suffix, boolean removeLastSuffix) {
        return CollectionUtils.toString(Arrays.asList(values), prefix, suffix, removeLastSuffix);
    }

    public static <T> String toString(List<T> values) {
        return CollectionUtils.toString(values, "", ", ", true);
    }

    public static <T> String toString(Iterable<T> values) {
        return CollectionUtils.toString(values, "", ", ", true);
    }

    public static <T> String toString(Collection<T> values) {
        return CollectionUtils.toString(values, "", ", ", true);
    }

    public static <T> String toString(List<T> values, String prefix, String suffix, boolean removeLastSuffix) {
        return CollectionUtils.toString(values, prefix, suffix, removeLastSuffix);
    }

    public static <T> String toString(Collection<T> values, String prefix, String suffix, boolean removeLastSuffix) {
        return CollectionUtils.toString(values, prefix, suffix, removeLastSuffix);
    }

    public static <T> String toString(Iterable<T> values, String prefix, String suffix, boolean removeLastSuffix) {
        StringBuilder sb = new StringBuilder();
        for (T value : values) {
            sb.append(prefix).append(value).append(suffix);
        }
        if (removeLastSuffix && sb.length() >= suffix.length()) {
            sb.setLength(sb.length() - suffix.length());
        }
        return sb.toString();
    }

    public static <T> int increment(T item, Map<T, Integer> map) {
        return CollectionUtils.add(item, 1, map);
    }

    public static <T> int add(T item, int toAdd, Map<T, Integer> map) {
        int newValue = map.getOrDefault(item, 0) + toAdd;
        map.put(item, newValue);
        return newValue;
    }

    public static <T> int decrement(T item, Map<T, Integer> map) {
        return CollectionUtils.add(item, -1, map);
    }

    public static <T> T getRandomWeightedElement(Map<T, ? extends Number> map) {
        if (map.isEmpty()) {
            return null;
        }
        double totalWeight = map.values().stream().mapToDouble(Number::doubleValue).sum();
        double randomWeight = Rand.ofDouble(totalWeight);
        for (Map.Entry<T, Number> entry : map.entrySet()) {
            if (!((randomWeight -= entry.getValue().doubleValue()) < 0.0)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <T> T getRandomWeightedElement(Collection<T> elements, Function<T, ? extends Number> chanceExtractor) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        return (T)CollectionUtils.getRandomWeightedElement(elements.stream().collect(Collectors.toMap(x -> x, chanceExtractor)));
    }

    public static int getFirstAvailableID(Collection<Integer> ids, int minID) {
        HashSet<Integer> idSet = new HashSet<Integer>(ids);
        int availableId = minID;
        while (idSet.contains(availableId)) {
            ++availableId;
        }
        return availableId;
    }

    @NotNull
    public static List<String> toStringList(Collection<?> collection) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object entry : collection) {
            list.add(entry.toString());
        }
        return list;
    }
}

