/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public class WorldGuardUtils {
    private static final Logger log = Logger.getLogger(WorldGuardUtils.class.getName());

    public static Set<ProtectedRegion> getRegionsAt(Location location) {
        RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)location.getWorld()));
        return regionManager == null ? Collections.emptySet() : regionManager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)location)).getRegions();
    }

    @Deprecated
    public static boolean isInRegion(Location location, String region, String world) {
        return WorldGuardUtils.isInRegion(location, region, location.getWorld());
    }

    @Deprecated
    public static boolean isInRegion(Location location, String region, World world) {
        return WorldGuardUtils.isInRegion(location, region);
    }

    public static boolean isInRegion(Location location, String region) {
        ProtectedRegion reg;
        if (location == null || region == null) {
            return false;
        }
        RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)location.getWorld()));
        return regionManager != null && (reg = regionManager.getRegion(region)) != null && reg.contains(BukkitAdapter.asBlockVector((Location)location));
    }

    @Nullable
    public static ProtectedRegion getRegion(String region, String world) {
        return WorldGuardUtils.getRegion(region, Bukkit.getWorld((String)world));
    }

    @Nullable
    public static ProtectedRegion getRegion(String region, World world) {
        if (region == null || world == null) {
            return null;
        }
        RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
        if (regionManager == null) {
            return null;
        }
        return regionManager.getRegion(region);
    }

    public static int setFlags(ProtectedRegion region, Map<String, String> flags) {
        AtomicInteger applied = new AtomicInteger();
        flags.forEach((flag, value) -> {
            try {
                Flag flagInstance = Flags.fuzzyMatchFlag((FlagRegistry)WorldGuard.getInstance().getFlagRegistry(), (String)flag);
                Object flagValue = flagInstance.parseInput(FlagContext.create().setInput(value).build());
                region.setFlag(flagInstance, flagValue);
                applied.getAndIncrement();
            }
            catch (Exception e) {
                log.warning("Cannot parse flag %s with value %s".formatted(flag, value));
            }
        });
        return applied.get();
    }

    public static ProtectedCuboidRegion createRegion(Location pos1, Location pos2, String name) {
        if (pos1.getWorld() != pos2.getWorld()) {
            throw new IllegalArgumentException("pos1.world != pos2.world");
        }
        RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)pos1.getWorld()));
        regionManager.removeRegion(name);
        ProtectedCuboidRegion region = new ProtectedCuboidRegion(name, BukkitAdapter.asBlockVector((Location)pos1), BukkitAdapter.asBlockVector((Location)pos2));
        regionManager.addRegion((ProtectedRegion)region);
        return region;
    }
}

