/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag;

import com.saicone.rtag.Rtag;
import com.saicone.rtag.tag.TagCompound;
import com.saicone.rtag.util.OptionalType;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;

public abstract class RtagEditor<T, EditorT extends RtagEditor<T, EditorT>> {
    protected final Rtag rtag;
    protected final T typeObject;
    protected Object literalObject;
    protected Object tag;

    public RtagEditor(Rtag rtag, T typeObject) {
        this.rtag = rtag;
        this.typeObject = typeObject;
        this.literalObject = this.getLiteralObject(typeObject);
        this.tag = this.getTag(this.literalObject);
    }

    public RtagEditor(Rtag rtag, T typeObject, Object literalObject) {
        this.rtag = rtag;
        this.typeObject = typeObject;
        this.literalObject = literalObject;
        this.tag = this.getTag(literalObject);
    }

    public RtagEditor(Rtag rtag, T typeObject, Object literalObject, Object tag) {
        this.rtag = rtag;
        this.typeObject = typeObject;
        this.literalObject = literalObject;
        this.tag = tag;
    }

    protected EditorT getEditor() {
        return (EditorT)this;
    }

    public Rtag getRtag() {
        return this.rtag;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public Object getObject() {
        return this.literalObject;
    }

    public T getTypeObject() {
        return this.typeObject;
    }

    public Object getLiteralObject() {
        return this.literalObject;
    }

    public abstract Object getLiteralObject(T var1);

    public Object getTag() {
        return this.tag;
    }

    public abstract Object getTag(Object var1);

    public abstract T load();

    public void update() {
        this.update(this.getLiteralObject(this.typeObject));
    }

    public void update(Object object) {
        this.literalObject = object;
        this.set(this.getTag(object));
    }

    public boolean hasTag() {
        return this.getTag() != null;
    }

    public boolean hasTag(Object ... path) {
        return this.getExact(path) != null;
    }

    public boolean notHasTag() {
        return !this.hasTag();
    }

    public boolean notHasTag(Object ... path) {
        return !this.hasTag(path);
    }

    public <E extends Enum<E>> boolean hasEnum(E element, Object ... path) {
        return this.hasBitField(this.getBitField(path), element.ordinal());
    }

    public <E extends Enum<E>> boolean hasEnum(E[] elements, Object ... path) {
        return this.hasBitField(this.getBitField(path), this.enumOrdinals((Enum[])elements));
    }

    public boolean hasEnum(int ordinal, Object ... path) {
        return this.hasBitField(this.getBitField(path), ordinal);
    }

    public boolean hasEnum(int[] ordinals, Object ... path) {
        return this.hasBitField(this.getBitField(path), ordinals);
    }

    private boolean hasBitField(int bitField, int ... ordinals) {
        for (int ordinal : ordinals) {
            byte bit = (byte)(1 << ordinal);
            if ((bitField & bit) == bit) continue;
            return false;
        }
        return bitField > 0;
    }

    public boolean add(Object value, Object ... path) {
        try {
            return this.rtag.add(this.getTag(), value, path);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public <E extends Enum<E>> boolean addEnum(E element, Object ... path) {
        return this.addEnum(new int[]{element.ordinal()}, path);
    }

    public <E extends Enum<E>> boolean addEnum(E[] elements, Object ... path) {
        return this.addEnum(this.enumOrdinals((Enum[])elements), path);
    }

    public boolean addEnum(int ordinal, Object ... path) {
        return this.addEnum(new int[]{ordinal}, path);
    }

    public boolean addEnum(int[] ordinals, Object ... path) {
        int bitField = this.getBitField(path);
        for (int ordinal : ordinals) {
            byte bit = (byte)(1 << ordinal);
            bitField |= bit;
        }
        return this.set(bitField, path);
    }

    public boolean set(Object value) {
        Object tag = this.rtag.newTag(value);
        if (TagCompound.isTagCompound(tag)) {
            this.tag = tag;
            return true;
        }
        return false;
    }

    public boolean set(Object value, Object ... path) {
        try {
            return this.rtag.set(this.getTag(), value, path);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public <E extends Enum<E>> boolean setEnum(E element, Object ... path) {
        return this.setEnum(new int[]{element.ordinal()}, path);
    }

    public <E extends Enum<E>> boolean setEnum(E[] elements, Object ... path) {
        return this.setEnum(this.enumOrdinals((Enum[])elements), path);
    }

    public boolean setEnum(int ordinal, Object ... path) {
        return this.setEnum(new int[]{ordinal}, path);
    }

    public boolean setEnum(int[] ordinals, Object ... path) {
        int bitField = 0;
        for (int ordinal : ordinals) {
            byte bit = (byte)(1 << ordinal);
            bitField |= bit;
        }
        return this.set(bitField, path);
    }

    public boolean merge(Object value, boolean replace) {
        return TagCompound.merge(this.getTag(), this.rtag.newTag(value), replace);
    }

    public boolean merge(Object value, boolean replace, Object ... path) {
        return this.rtag.merge(this.getTag(), value, replace, path);
    }

    public boolean deepMerge(Object value, boolean replace) {
        return TagCompound.merge(this.getTag(), this.rtag.newTag(value), replace, true);
    }

    public boolean deepMerge(Object value, boolean replace, Object ... path) {
        return this.rtag.deepMerge(this.getTag(), value, replace, path);
    }

    public boolean move(Object[] from, Object[] to) {
        return this.rtag.move(this.getTag(), from, to);
    }

    public boolean move(Object[] from, Object[] to, boolean clear) {
        return this.rtag.move(this.getTag(), from, to, clear);
    }

    public boolean remove(Object ... path) {
        try {
            return this.rtag.set(this.getTag(), null, path);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public <E extends Enum<E>> boolean removeEnum(E element, Object ... path) {
        return this.removeEnum(new int[]{element.ordinal()}, path);
    }

    public <E extends Enum<E>> boolean removeEnum(E[] elements, Object ... path) {
        return this.removeEnum(this.enumOrdinals((Enum[])elements), path);
    }

    public boolean removeEnum(int ordinal, Object ... path) {
        return this.removeEnum(new int[]{ordinal}, path);
    }

    public boolean removeEnum(int[] ordinals, Object ... path) {
        int bitField = this.getBitField(path);
        if (bitField < 1) {
            return true;
        }
        for (int ordinal : ordinals) {
            byte bit = (byte)(1 << ordinal);
            bitField &= ~bit;
        }
        return this.set(bitField, path);
    }

    public Map<String, Object> get() {
        return (Map)OptionalType.cast(this.rtag.getTagValue(this.tag));
    }

    public <V> V get(Object ... path) {
        try {
            return (V)this.rtag.get(this.tag, path);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public OptionalType getOptional(Object ... path) {
        Object value;
        try {
            value = this.rtag.getTagValue(this.rtag.getExact(this.tag, path));
        }
        catch (Throwable t) {
            t.printStackTrace();
            value = null;
        }
        return OptionalType.of(value);
    }

    public Object getExact(Object ... path) {
        try {
            return this.rtag.getExact(this.tag, path);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public int getBitField(Object ... path) {
        return this.getOptional(path).asInt(0);
    }

    public EditorT edit(Consumer<EditorT> consumer) {
        EditorT editor = this.getEditor();
        consumer.accept(editor);
        return editor;
    }

    private <E extends Enum<E>> int[] enumOrdinals(E[] elements) {
        int[] ordinals = new int[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            ordinals[i] = ((Enum)elements[i]).ordinal();
        }
        return ordinals;
    }
}

