/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag.item.mirror;

import com.saicone.rtag.item.ItemMirror;
import com.saicone.rtag.tag.TagBase;
import com.saicone.rtag.tag.TagCompound;
import com.saicone.rtag.tag.TagList;
import com.saicone.rtag.util.EnchantmentTag;
import java.util.HashMap;
import java.util.Map;

public class IEnchantMirror
implements ItemMirror {
    public static final Map<Object, Object> fromString = new HashMap<Object, Object>();
    public static final Map<Object, Object> fromShort = new HashMap<Object, Object>();
    private final Map<Object, Object> map;
    private final String bookKey;
    private final String fromKey;
    private final String toKey;

    public IEnchantMirror(float version) {
        if (version < 13.0f) {
            this.map = fromString;
            this.bookKey = "StoredEnchantments";
            this.fromKey = "Enchantments";
            this.toKey = "ench";
        } else {
            this.map = fromShort;
            this.bookKey = "StoredEnchantments";
            this.fromKey = "ench";
            this.toKey = "Enchantments";
        }
    }

    public IEnchantMirror(Map<Object, Object> map, String bookKey, String fromKey, String toKey) {
        this.map = map;
        this.bookKey = bookKey;
        this.fromKey = fromKey;
        this.toKey = toKey;
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    @Override
    public float getDeprecationVersion() {
        return 13.0f;
    }

    @Override
    public void upgrade(Object compound, String id, Object components, float from, float to) {
        if (to >= 13.0f && from < 13.0f) {
            this.processEnchants(components, id.equalsIgnoreCase("minecraft:enchanted_book"));
        }
    }

    @Override
    public void downgrade(Object compound, String id, Object components, float from, float to) {
        if (from >= 13.0f && to < 13.0f) {
            this.processEnchants(components, id.equalsIgnoreCase("minecraft:enchanted_book"));
        }
    }

    public void processEnchants(Object tag, boolean book) {
        Object enchants = TagCompound.get(tag, book ? this.bookKey : this.fromKey);
        if (enchants != null) {
            int size = TagList.size(enchants);
            for (int i = 0; i < size; ++i) {
                Object id;
                Object enchant = TagList.get(enchants, i);
                Object value = TagBase.getValue(TagCompound.get(enchant, "id"));
                if (value == null || (id = this.map.get(value)) == null) continue;
                TagCompound.set(enchant, "id", id);
            }
            if (!book) {
                TagCompound.set(tag, this.toKey, enchants);
                TagCompound.remove(tag, this.fromKey);
            }
        }
    }

    static {
        try {
            for (EnchantmentTag enchant : EnchantmentTag.LEGACY_VALUES) {
                String name = "minecraft:" + enchant.name().toLowerCase();
                fromShort.put(enchant.getId(), TagBase.newTag(name));
                fromString.put(name, TagBase.newTag(enchant.getId()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

