/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.config;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import ru.cwcode.cwutils.collections.EnumUtils;
import ru.cwcode.cwutils.config.ItemStackConstituents;
import ru.cwcode.cwutils.items.ItemBuilder;
import ru.cwcode.cwutils.items.ItemBuilderFactory;
import ru.cwcode.cwutils.messages.Message;
import ru.cwcode.cwutils.messages.PaperMessage;
import ru.cwcode.cwutils.server.PaperServerUtils;

@Deprecated(forRemoval=true)
public class ConfigUtils {
    public static String getPath(String root, String ... keys) {
        StringBuilder path = new StringBuilder(root);
        for (String key : keys) {
            path.append(".");
            path.append(key);
        }
        return path.toString();
    }

    public static Component getComponent(String json) {
        Component component;
        if (json == null || json.isEmpty()) {
            component = Component.text("\u041f\u0440\u0435\u0434\u043c\u0435\u0442");
        } else {
            try {
                component = json.matches("^\\{.*}$") ? GsonComponentSerializer.gson().deserialize((Object)json) : LegacyComponentSerializer.legacyAmpersand().deserialize(json.replace("\u00a7", "&"));
            }
            catch (Exception exception) {
                component = Component.text(json).style(Style.style(TextColor.color(255, 255, 255)));
            }
        }
        return component.decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    public static Component[] getComponents(List<String> json) {
        Component[] components;
        if (json.isEmpty()) {
            components = new Component[]{Component.text("\u041f\u0440\u0435\u0434\u043c\u0435\u0442").decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE)};
        } else {
            components = new Component[json.size()];
            for (int i = 0; i < json.size(); ++i) {
                try {
                    if (json.get(i).matches("^\\{.*}$")) {
                        components[i] = GsonComponentSerializer.gson().deserialize((Object)json.get(i)).decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE);
                        continue;
                    }
                    components[i] = LegacyComponentSerializer.legacyAmpersand().deserialize(json.get(i).replace("\u00a7", "&")).decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE);
                    continue;
                }
                catch (Exception exception) {
                    components[i] = ((TextComponent)Component.text(json.get(i)).style(Style.style(TextColor.color(255, 255, 255)))).decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE);
                }
            }
        }
        return components;
    }

    public static ItemStack loadItemStack(File file, YamlConfiguration config, String path) {
        String full_path = ConfigUtils.getPath(path, ItemStackConstituents.type.name());
        String item_type_name = config.getString(full_path, "dirt").toUpperCase();
        Material item_type = Material.matchMaterial((String)item_type_name);
        if (item_type == null || !PaperServerUtils.isVersionBefore1_16_5() && item_type.isAir() || item_type.equals((Object)Material.AIR)) {
            item_type = Material.DIRT;
            PaperMessage.getInstance("\u00a7c[\u00a74" + path + "\u00a7c]: \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u00a74" + item_type_name + "\u00a7c \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!").send((Audience)Bukkit.getConsoleSender());
        }
        full_path = ConfigUtils.getPath(path, ItemStackConstituents.amount.name());
        int item_amount = Math.max(Math.min(config.getInt(full_path, 1), 64), 1);
        ItemStack item = new ItemStack(item_type, item_amount);
        ItemBuilder itemFactory = ItemBuilderFactory.of(item);
        full_path = ConfigUtils.getPath(path, ItemStackConstituents.name.name());
        if (config.contains(full_path)) {
            Component item_name = ConfigUtils.getComponent(config.getString(full_path));
            itemFactory.name(item_name);
        }
        if (config.contains(full_path = ConfigUtils.getPath(path, ItemStackConstituents.lore.name()))) {
            Component[] item_lore = ConfigUtils.getComponents(config.getStringList(full_path));
            itemFactory.description(Arrays.asList(item_lore));
        }
        if (config.contains(full_path = ConfigUtils.getPath(path, ItemStackConstituents.model.name()))) {
            int model = Math.max(config.getInt(full_path, 0), 0);
            itemFactory.model(model);
        }
        if (itemFactory.isPotionMeta() && config.contains(ConfigUtils.getPath(path, ItemStackConstituents.effects.name()))) {
            for (String potion_effect : config.getConfigurationSection(ConfigUtils.getPath(path, ItemStackConstituents.effects.name())).getKeys(false)) {
                PotionEffectType effect_type = PotionEffectType.getByName((String)potion_effect.toUpperCase());
                if (effect_type != null) {
                    int duration = Math.max(config.getInt(ConfigUtils.getPath(path, ItemStackConstituents.effects.name(), potion_effect, "duration"), 1), 1) * 20;
                    int level = Math.max(config.getInt(ConfigUtils.getPath(path, ItemStackConstituents.effects.name(), potion_effect, "level"), 1), 1) - 1;
                    itemFactory.customEffect(effect_type, duration, level);
                    continue;
                }
                PaperMessage.getInstance("\u00a7c[\u00a74" + path + "\u00a7c]: \u044d\u0444\u0444\u0435\u043a\u0442 \u00a74" + potion_effect + "\u00a7c \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!").send((Audience)Bukkit.getConsoleSender());
            }
        }
        if (itemFactory.isSkullMeta() && config.contains(full_path = ConfigUtils.getPath(path, ItemStackConstituents.head_base64.name()))) {
            String base64 = config.getString(full_path, "null");
            full_path = ConfigUtils.getPath(path, ItemStackConstituents.head_uuid.name());
            UUID uuid = null;
            if (config.contains(full_path)) {
                try {
                    uuid = UUID.fromString(config.getString(full_path, "null"));
                }
                catch (Exception effect_type) {
                    // empty catch block
                }
            }
            if (uuid == null) {
                uuid = UUID.randomUUID();
                config.set(full_path, (Object)uuid.toString());
                ConfigUtils.saveConfig(file, config);
            }
            PlayerProfile profile = Bukkit.createProfile((UUID)uuid, (String)"Head");
            profile.getProperties().add(new ProfileProperty("textures", base64));
            itemFactory.playerProfile(profile);
        }
        if (config.contains(ConfigUtils.getPath(path, ItemStackConstituents.enchantments.name()))) {
            for (String enchantment_name : config.getConfigurationSection(ConfigUtils.getPath(path, ItemStackConstituents.enchantments.name())).getKeys(false)) {
                Enchantment enchantment = Enchantment.getByName((String)enchantment_name);
                if (enchantment != null) {
                    int level = Math.max(config.getInt(ConfigUtils.getPath(path, ItemStackConstituents.enchantments.name(), enchantment_name), 1), 1);
                    itemFactory.enchantment(enchantment, level);
                    continue;
                }
                PaperMessage.getInstance("\u00a7c[\u00a74" + path + "\u00a7c]: \u0437\u0430\u0447\u0430\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u00a74" + enchantment_name + "\u00a7c \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            }
        }
        return itemFactory.build();
    }

    public static boolean saveConfig(File file, YamlConfiguration config) {
        try {
            config.save(file);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Map<String, Object> serialize(Object instance) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Field field : instance.getClass().getFields()) {
            if (Modifier.isTransient(field.getModifiers())) continue;
            String key = field.getName();
            try {
                if (!field.canAccess(instance)) {
                    field.setAccessible(true);
                }
                Object value = field.get(instance);
                map.put(key, value);
            }
            catch (Exception ex) {
                PaperMessage.getInstance("\u00a7c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043f\u043e\u043b\u0435 \u00a74" + key).send((Audience)Bukkit.getConsoleSender());
            }
        }
        return map;
    }

    public static void deserialize(Object instance, Map<String, Object> map) {
        for (Field field : instance.getClass().getFields()) {
            String key;
            if (Modifier.isTransient(field.getModifiers()) || !map.containsKey(key = field.getName())) continue;
            ConfigUtils.setField(instance, key, map.get(key));
        }
    }

    public static void setField(Object instance, String key, Object value) {
        try {
            Field field = instance.getClass().getField(key);
            if (!field.canAccess(instance)) {
                field.setAccessible(true);
            }
            if (field.getType().isEnum()) {
                value = EnumUtils.getEnumInstance((Enum[])EnumUtils.getEnumValues(field.getType()), (String)String.valueOf(value)).orElse(null);
            }
            if (field.getType().isAssignableFrom(Message.class)) {
                value = new PaperMessage(String.valueOf(value));
            }
            field.set(instance, value);
        }
        catch (Exception ex) {
            PaperMessage.getInstance("\u00a7c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u043e\u043b\u0435 \u00a74" + key).send((Audience)Bukkit.getConsoleSender());
        }
    }
}

