/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.persistent;

import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class PersistentFieldWrapper<Z> {
    private final PersistentDataType<?, Z> type;
    private final NamespacedKey key;

    public PersistentFieldWrapper(PersistentDataType<?, Z> type, NamespacedKey key) {
        this.type = type;
        this.key = key;
    }

    public PersistentFieldWrapper(PersistentDataType<?, Z> type, String key) {
        this(type, NamespacedKey.fromString((String)key));
    }

    public Z getOrNull(PersistentDataContainer container) {
        return (Z)container.get(this.key, this.type);
    }

    public Optional<Z> get(PersistentDataContainer container) {
        return Optional.ofNullable(this.getOrNull(container));
    }

    public Optional<Z> set(PersistentDataContainer container, Z value) {
        Optional<Z> previous = this.get(container);
        container.set(this.key, this.type, value);
        return previous;
    }

    public Optional<Z> remove(PersistentDataContainer container) {
        Optional<Z> previous = this.get(container);
        container.remove(this.key);
        return previous;
    }

    public Z getOrNull(PersistentDataHolder holder) {
        return this.getOrNull(holder.getPersistentDataContainer());
    }

    public Optional<Z> get(PersistentDataHolder holder) {
        return this.get(holder.getPersistentDataContainer());
    }

    public Optional<Z> set(PersistentDataHolder holder, Z value) {
        return this.set(holder.getPersistentDataContainer(), value);
    }

    public Optional<Z> remove(PersistentDataHolder holder) {
        return this.remove(holder.getPersistentDataContainer());
    }
}

