/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.persistent;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class PersistentWrapper {
    protected static final Gson gson = new Gson();
    protected static final LoadingCache<String, NamespacedKey> STRING_TO_NAMESPACED_KEY_CACHE = CacheBuilder.newBuilder().softValues().maximumSize(1000L).build(CacheLoader.from(NamespacedKey::fromString));
    protected PersistentDataContainer container;
    protected List<Field<?>> fields = new LinkedList();

    public PersistentWrapper(PersistentDataContainer container) {
        this.container = container;
    }

    public PersistentWrapper(PersistentDataHolder holder) {
        this.container = holder.getPersistentDataContainer();
    }

    public void clear() {
        this.fields.forEach(Field::remove);
    }

    public Map<NamespacedKey, Object> serialize() {
        return this.fields.stream().collect(Collectors.toMap(x -> x.key, Field::getOrNull));
    }

    public String toString() {
        return gson.toJson(this.fields.stream().collect(Collectors.toMap(x -> x.key.toString(), Field::getOrNull)));
    }

    protected <Z> Field<Z> bind(PersistentDataType<?, Z> type, NamespacedKey key) {
        Field<Z> field = new Field<Z>(type, key);
        this.fields.add(field);
        return field;
    }

    protected <Z> Field<Z> bind(PersistentDataType<?, Z> type, String namespacedKey) {
        return this.bind(type, (NamespacedKey)STRING_TO_NAMESPACED_KEY_CACHE.getUnchecked((Object)namespacedKey));
    }

    public class Field<Z> {
        private final PersistentDataType<?, Z> type;
        private final NamespacedKey key;

        public Field(PersistentDataType<?, Z> type, NamespacedKey key) {
            this.type = type;
            this.key = key;
        }

        public Z getOrNull() {
            return (Z)PersistentWrapper.this.container.get(this.key, this.type);
        }

        public Optional<Z> get() {
            return Optional.ofNullable(this.getOrNull());
        }

        public Optional<Z> set(Z value) {
            Optional<Z> previous = this.get();
            PersistentWrapper.this.container.set(this.key, this.type, value);
            return previous;
        }

        public Optional<Z> remove() {
            Optional<Z> previous = this.get();
            PersistentWrapper.this.container.remove(this.key);
            return previous;
        }
    }
}

