/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.asm.define;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import revxrsal.asm.define.ClassDefiner;

final class GeneratedDefiner
implements ClassDefiner {
    private static final Map<ClassLoader, GClassLoader> loaders = new HashMap<ClassLoader, GClassLoader>();

    GeneratedDefiner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Class<?> defineClass(@NotNull ClassLoader classLoader, @NotNull String name, byte[] data) {
        GClassLoader loader = loaders.computeIfAbsent(classLoader, GClassLoader::new);
        Object object = loader.getClassLoadingLock(name);
        synchronized (object) {
            if (loader.hasClass(name)) {
                throw new IllegalArgumentException("Class " + name + " is already defined in this class loader!");
            }
            Class<?> c = loader.define(name, data);
            assert (c.getName().equals(name));
            return c;
        }
    }

    private static class GClassLoader
    extends ClassLoader {
        private GClassLoader(ClassLoader parent) {
            super(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class<?> define(@NotNull String name, byte[] data) {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                assert (!this.hasClass(name));
                Class<?> c = this.defineClass(name, data, 0, data.length);
                this.resolveClass(c);
                return c;
            }
        }

        @Override
        @NotNull
        public Object getClassLoadingLock(@NotNull String name) {
            return super.getClassLoadingLock(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasClass(@NotNull String name) {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                try {
                    Class.forName(name);
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

