/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.arguments;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.api.Sender;

public class EnumArg
extends Argument {
    private final String name;
    private Map<String, Enum> values;

    public EnumArg(Enum[] values, String name) {
        this.name = name;
        this.values = Stream.of(values).collect(Collectors.toMap(Enum::name, anEnum -> anEnum, (o, o2) -> o, HashMap::new));
    }

    @Override
    public boolean valid(String s) {
        return this.values.containsKey(s);
    }

    public Set<String> completions(Sender commandSender) {
        return this.values.keySet();
    }

    @Override
    public Object map() {
        return this.values.get(this.raw);
    }

    @Override
    public String argumentName() {
        return this.name;
    }
}

