/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.permissions;

import org.jetbrains.annotations.NotNull;
import ru.cwcode.commands.permissions.PermissionGenerationStrategy;
import ru.cwcode.commands.permissions.ProcessResult;

public class DefaultPermissionGenerationStrategy
implements PermissionGenerationStrategy {
    @Override
    public ProcessResult processCommand(String currentPermission, String commandName) {
        if (currentPermission == null) {
            return new ProcessResult(commandName);
        }
        if (DefaultPermissionGenerationStrategy.isStatic(currentPermission)) {
            return new ProcessResult(DefaultPermissionGenerationStrategy.parseStatic(currentPermission), currentPermission);
        }
        if (!currentPermission.isEmpty()) {
            return new ProcessResult(currentPermission);
        }
        return new ProcessResult("");
    }

    @Override
    public ProcessResult processSubCommand(String previousPermissions, String currentPermission, String commandName) {
        if (DefaultPermissionGenerationStrategy.isStatic(currentPermission)) {
            return new ProcessResult(DefaultPermissionGenerationStrategy.parseStatic(currentPermission), currentPermission);
        }
        if (DefaultPermissionGenerationStrategy.isStatic(previousPermissions)) {
            return new ProcessResult(DefaultPermissionGenerationStrategy.parseStatic(previousPermissions), previousPermissions);
        }
        return new ProcessResult(previousPermissions + "." + currentPermission);
    }

    @Override
    public String processArgumentSet(String previousPermissions, String argumentPermission, String subCommandPermission) {
        if (DefaultPermissionGenerationStrategy.isStatic(argumentPermission)) {
            return DefaultPermissionGenerationStrategy.parseStatic(argumentPermission);
        }
        if (DefaultPermissionGenerationStrategy.isStatic(previousPermissions)) {
            return DefaultPermissionGenerationStrategy.parseStatic(previousPermissions);
        }
        if (DefaultPermissionGenerationStrategy.notEmpty(argumentPermission)) {
            if (DefaultPermissionGenerationStrategy.notEmpty(previousPermissions)) {
                return previousPermissions + "." + argumentPermission;
            }
            return argumentPermission;
        }
        if (DefaultPermissionGenerationStrategy.notEmpty(previousPermissions)) {
            return previousPermissions;
        }
        return "";
    }

    @NotNull
    private static String parseStatic(String staticPermission) {
        return staticPermission.substring(1);
    }

    private static boolean isStatic(String permission) {
        return permission != null && permission.startsWith("$");
    }

    private static boolean notEmpty(String permission) {
        return permission != null && !permission.isEmpty();
    }
}

