/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.bossBar;

import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.cwutils.text.nanoid.NanoID;

public class LegacyBossBarAdapter {
    private static final HashMap<UUID, org.bukkit.boss.BossBar> cachedBossBars = new HashMap();
    private static final HashMap<UUID, NamespacedKey> cachedBossBarsKeys = new HashMap();
    private static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().character('\u00a7').build();

    public static void remove(UUID uuid) {
        cachedBossBars.remove(uuid);
        NamespacedKey key = cachedBossBarsKeys.remove(uuid);
        if (key != null) {
            Bukkit.removeBossBar((NamespacedKey)key);
        }
    }

    public static org.bukkit.boss.BossBar get(UUID uuid) {
        return cachedBossBars.get(uuid);
    }

    public static org.bukkit.boss.BossBar merge(UUID uuid, BossBar bossBar) {
        Component name = bossBar.name();
        float progress = bossBar.progress();
        Set<BossBar.Flag> flags = bossBar.flags();
        BossBar.Color color = bossBar.color();
        BossBar.Overlay overlay = bossBar.overlay();
        BarStyle barStyle = switch (overlay) {
            case BossBar.Overlay.NOTCHED_6 -> BarStyle.SEGMENTED_6;
            case BossBar.Overlay.NOTCHED_10 -> BarStyle.SEGMENTED_10;
            case BossBar.Overlay.NOTCHED_12 -> BarStyle.SEGMENTED_12;
            case BossBar.Overlay.NOTCHED_20 -> BarStyle.SEGMENTED_20;
            default -> BarStyle.SOLID;
        };
        BarColor barColor = BarColor.valueOf((String)color.name());
        Set barFlags = flags.stream().map(flag -> switch (flag) {
            default -> throw new IncompatibleClassChangeError();
            case BossBar.Flag.PLAY_BOSS_MUSIC -> BarFlag.PLAY_BOSS_MUSIC;
            case BossBar.Flag.DARKEN_SCREEN -> BarFlag.DARKEN_SKY;
            case BossBar.Flag.CREATE_WORLD_FOG -> BarFlag.CREATE_FOG;
        }).collect(Collectors.toSet());
        org.bukkit.boss.BossBar bossBarLegacy = cachedBossBars.get(uuid);
        if (bossBarLegacy == null) {
            bossBarLegacy = LegacyBossBarAdapter.createBossBar(uuid, barColor, barStyle, (BarFlag[])barFlags.toArray(BarFlag[]::new));
        }
        bossBarLegacy.setProgress((double)progress);
        bossBarLegacy.setStyle(barStyle);
        bossBarLegacy.setTitle(LEGACY_COMPONENT_SERIALIZER.serialize(name));
        bossBarLegacy.setColor(barColor);
        for (BarFlag value : BarFlag.values()) {
            boolean shouldBe = barFlags.contains(value);
            boolean actual = bossBarLegacy.hasFlag(value);
            if (shouldBe && !actual) {
                bossBarLegacy.addFlag(value);
                continue;
            }
            if (shouldBe || !actual) continue;
            bossBarLegacy.removeFlag(value);
        }
        return bossBarLegacy;
    }

    @NotNull
    public static org.bukkit.boss.BossBar createBossBar(UUID uuid, BarColor barColor, BarStyle barStyle, BarFlag ... barFlags) {
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)("cwutils:" + NanoID.randomNanoId().toLowerCase()));
        KeyedBossBar bossBarLegacy = Bukkit.createBossBar((NamespacedKey)namespacedKey, (String)"loading...", (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])barFlags);
        cachedBossBars.put(uuid, (org.bukkit.boss.BossBar)bossBarLegacy);
        cachedBossBarsKeys.put(uuid, namespacedKey);
        return bossBarLegacy;
    }
}

