/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.items.compare;

import java.util.List;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;
import ru.cwcode.cwutils.items.compare.CompareService;
import ru.cwcode.cwutils.items.compare.ItemCompareService;
import ru.cwcode.cwutils.items.compare.PotionCompareService;

public final class CompareServiceProvider {
    private static final List<CompareService> services = List.of(new PotionCompareService(), new ItemCompareService());

    public static Optional<CompareService> find(ItemStack itemStack) {
        if (itemStack == null) {
            return Optional.empty();
        }
        for (CompareService service : services) {
            if (!service.supports(itemStack)) continue;
            return Optional.of(service);
        }
        return Optional.empty();
    }

    private CompareServiceProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

