/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.matrix;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class MatrixUtils {
    public static <T> T[][][] rotate(T[][][] array, int angle) {
        int ySize = array.length;
        int xSize = array[0].length;
        int zSize = array[0][0].length;
        Object rotated = array;
        switch (angle) {
            case 90: {
                rotated = (Object[][][])Array.newInstance(array.getClass().getComponentType().getComponentType().getComponentType(), ySize, zSize, xSize);
                for (int y = 0; y < ySize; ++y) {
                    for (int x = 0; x < xSize; ++x) {
                        for (int z = 0; z < zSize; ++z) {
                            rotated[y][z][xSize - 1 - x] = array[y][x][z];
                        }
                    }
                }
                break;
            }
            case 180: {
                rotated = (Object[][][])Array.newInstance(array.getClass().getComponentType().getComponentType().getComponentType(), ySize, xSize, zSize);
                for (int y = 0; y < ySize; ++y) {
                    for (int x = 0; x < xSize; ++x) {
                        for (int z = 0; z < zSize; ++z) {
                            rotated[y][xSize - 1 - x][zSize - 1 - z] = array[y][x][z];
                        }
                    }
                }
                break;
            }
            case 270: {
                rotated = (Object[][][])Array.newInstance(array.getClass().getComponentType().getComponentType().getComponentType(), ySize, zSize, xSize);
                for (int y = 0; y < ySize; ++y) {
                    for (int x = 0; x < xSize; ++x) {
                        for (int z = 0; z < zSize; ++z) {
                            rotated[y][zSize - 1 - z][x] = array[y][x][z];
                        }
                    }
                }
                break;
            }
        }
        return rotated;
    }

    public static Optional<Integer[]> findFirstPosition(Object[][][] array, Object element) {
        List<Integer[]> positions = MatrixUtils.findAllPositions(array, element);
        if (positions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(positions.get(0));
    }

    public static List<Integer[]> findAllPositions(Object[][][] array, Object element) {
        int ySize = array.length;
        int xSize = array[0].length;
        int zSize = array[0][0].length;
        ArrayList<Integer[]> positions = new ArrayList<Integer[]>();
        for (int y = 0; y < ySize; ++y) {
            for (int x = 0; x < xSize; ++x) {
                for (int z = 0; z < zSize; ++z) {
                    if (!array[y][x][z].equals(element)) continue;
                    positions.add(new Integer[]{y, x, z});
                }
            }
        }
        return positions;
    }

    private MatrixUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

